require File.dirname(__FILE__) + '/../test_helper'

class ThesisTest < Test::Unit::TestCase
  fixtures :theses, :quotations

  def test_first_sink
    assert_equal 1, theses(:first).sink.size
    assert_equal [theses(:third)], theses(:first).sink
  end
  def test_first_source
    assert_equal 1, theses(:first).source.size
    assert_equal [theses(:another)], theses(:first).source
  end
  def test_first_sink_count
    assert_equal 1, theses(:first).sink_count
  end
  def test_first_source_count
    assert_equal 1, theses(:first).source_count
  end
  def test_counter_inc
    Quotation.create(:thesis_id => theses(:first).id, :source_thesis_id => theses(:third).id)
    assert_equal 2, theses(:first).source_count
    assert_equal 2, theses(:third).sink_count

    assert_equal 1, theses(:first).sink_count
    assert_equal 1, theses(:third).source_count
  end
  def test_counter_dec
    quotations(:third).destroy
    assert_equal 0, theses(:first).sink_count
    assert_equal 0, theses(:third).source_count

    assert_equal 1, theses(:first).source_count
    assert_equal 1, theses(:third).sink_count
  end
end
