class Thesis < ActiveRecord::Base
  # Self-referential has_many :through associations
  # Thesis -++ Quotation
  has_many :quotations_as_sink, :foreign_key => 'thesis_id', :class_name => 'Quotation'
  has_many :source, :through => :quotations_as_sink

  has_many :quotations_as_source, :foreign_key => 'source_thesis_id', :class_name => 'Quotation'
  has_many :sink, :through => :quotations_as_source
end
