Dir.glob('**/*.rb') {|entry|
  phi_required_row = -1
  open(entry) {|f|
    while f.gets
      phi_required_row = $. if /require\s+['"]phi(\.[so|rb])?['"]/
      phi_required_row = -1 if /include\s+Phi/
    end
  }
  if phi_required_row != -1
    backup = entry+'~'
    print "rename #{entry} to #{backup}\n"
    File.rename entry, backup
    open(backup) {|f|
      open(entry, 'w') {|o|
        1.upto(phi_required_row){o.print f.gets}
        o.print <<EOT
include Phi
EOT
        while f.gets
          o.print
        end
      }
    }
  end
}
