unit uWin;

interface

uses Rubies, Windows, SHellAPI, SysUtils;

var
  mWin: Tvalue;

function ap_mWin: Tvalue;
procedure Init_win;

implementation

uses uStrUtils, ComObj, uPoint, uConv;

function ap_mWin: Tvalue;
begin
  result := mWin;
end;

function Win_set_capture(This, handle: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(SetCapture(FIX2INT(handle)));
end;

function Win_get_capture(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(GetCapture);
end;

function Win_release_capture(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(ReleaseCapture);
end;

function Win_invalidate_rect(This, handle, rect, erase: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(InvalidateRect(FIX2INT(handle), PRect(ap_data_get_struct(rect)), RTEST(erase)));
end;

function Win_get_cursor_pos(This: Tvalue): Tvalue; cdecl;
var
  point: TPoint;
  v: Tvalue;
begin
  GetCursorPos(point);
  v := Point_alloc(cPoint, point);
  result := v;
end;

function Win_get_key_state(This, key: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(GetKeyState(FIX2INT(key)));
end;

function Win_set_cursor(This, cur: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(SetCursor(FIX2INT(cur)));
end;

function Win_load_cursor(This, str: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(LoadCursor(HInstance, STR2CSTR(str)));
end;

function Win_shell_execute(This, handle, op, fname, param, dir, show_cmd: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(ShellExecute(
    FIX2INT(handle),
    PChar(STR2CSTR(op)),
    PChar(STR2CSTR(fname)),
    PChar(STR2CSTR(param)),
    PChar(STR2CSTR(dir)),
    FIX2INT(show_cmd)
  ));
end;

function Win_keybd_event(This, vk, sc, flags, extra: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
  keybd_event(
    FIX2INT(vk),
    FIX2INT(sc),
    FIX2INT(flags),
    FIX2INT(extra)
  );
end;

function Win_get_computer_name(This: Tvalue): Tvalue; cdecl;
var
  Name: array[0..MAX_COMPUTERNAME_LENGTH] of Char;
  nSize: DWORD;
begin
  nSize := MAX_COMPUTERNAME_LENGTH + 1;
  Win32Check(GetComputerName(Name, nSize));
  result := ap_String(Name);
end;

function Win_create_class_id(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(CreateClassID);
end;

procedure Init_win;
begin
  mWin := rb_define_module('Win');

  rb_define_const(mWin, 'PLATFORM', INT2FIX(Win32Platform));
  rb_define_const(mWin, 'PLATFORM_WIN32s', INT2FIX(VER_PLATFORM_WIN32s));
  rb_define_const(mWin, 'PLATFORM_WIN32_WINDOWS', INT2FIX(VER_PLATFORM_WIN32_WINDOWS));
  rb_define_const(mWin, 'PLATFORM_WIN32_NT', INT2FIX(VER_PLATFORM_WIN32_NT));
  rb_define_const(mWin, 'LANG', INT2FIX(SysLocale.PriLangID));
  rb_define_const(mWin, 'LANG_ENGLISH', INT2FIX(LANG_ENGLISH));
  rb_define_const(mWin, 'LANG_JAPANESE', INT2FIX(LANG_JAPANESE));

  rb_define_const(mWin, 'MAJOR', INT2FIX(Win32MajorVersion));
  rb_define_const(mWin, 'MINOR', INT2FIX(Win32MinorVersion));
  rb_define_const(mWin, 'BUILD', INT2FIX(Win32BuildNumber));
  rb_define_const(mWin, 'CSD', rb_str_new2(PChar(Win32CSDVersion)));

  rb_define_const(mWin, 'ETO_CLIPPED', INT2FIX(ETO_CLIPPED));
  rb_define_const(mWin, 'ETO_OPAQUE', INT2FIX(ETO_OPAQUE));

  rb_define_const(mWin, 'SW_HIDE', INT2FIX(SW_HIDE));
  rb_define_const(mWin, 'SW_SHOWNORMAL', INT2FIX(SW_SHOWNORMAL));
  rb_define_const(mWin, 'SW_NORMAL', INT2FIX(SW_NORMAL));
  rb_define_const(mWin, 'SW_SHOWMINIMIZED', INT2FIX(SW_SHOWMINIMIZED));
  rb_define_const(mWin, 'SW_SHOWMAXIMIZED', INT2FIX(SW_SHOWMAXIMIZED));
  rb_define_const(mWin, 'SW_MAXIMIZE', INT2FIX(SW_MAXIMIZE));
  rb_define_const(mWin, 'SW_SHOWNOACTIVATE', INT2FIX(SW_SHOWNOACTIVATE));
  rb_define_const(mWin, 'SW_SHOW', INT2FIX(SW_SHOW));
  rb_define_const(mWin, 'SW_MINIMIZE', INT2FIX(SW_MINIMIZE));
  rb_define_const(mWin, 'SW_SHOWMINNOACTIVE', INT2FIX(SW_SHOWMINNOACTIVE));
  rb_define_const(mWin, 'SW_SHOWNA', INT2FIX(SW_SHOWNA));
  rb_define_const(mWin, 'SW_RESTORE', INT2FIX(SW_RESTORE));
  rb_define_const(mWin, 'SW_SHOWDEFAULT', INT2FIX(SW_SHOWDEFAULT));
  rb_define_const(mWin, 'SW_MAX', INT2FIX(SW_MAX));

  rb_define_const(mWin, 'CE_FRAME', INT2FIX(CE_FRAME));
  rb_define_const(mWin, 'CE_OVERRUN', INT2FIX(CE_OVERRUN));
  rb_define_const(mWin, 'CE_RXPARITY', INT2FIX(CE_RXPARITY));

  rb_define_const(mWin, 'DMPAPER_A3', INT2FIX(DMPAPER_A3));
  rb_define_const(mWin, 'DMPAPER_A4', INT2FIX(DMPAPER_A4));
  rb_define_const(mWin, 'DMPAPER_A5', INT2FIX(DMPAPER_A5));

  rb_define_const(mWin, 'DMORIENT_PORTRAIT', INT2FIX(DMORIENT_PORTRAIT));
  rb_define_const(mWin, 'DMORIENT_LANDSCAPE', INT2FIX(DMORIENT_LANDSCAPE));

  rb_define_const(mWin, 'KEYEVENTF_KEYUP', INT2FIX(KEYEVENTF_KEYUP));

  rb_define_module_function(mWin, 'set_capture', @Win_set_capture, 1);
  rb_define_module_function(mWin, 'get_capture', @Win_get_capture, 0);
  rb_define_module_function(mWin, 'release_capture', @Win_release_capture, 0);
  rb_define_module_function(mWin, 'invalidate_rect', @Win_invalidate_rect, 3);
  rb_define_module_function(mWin, 'get_cursor_pos', @Win_get_cursor_pos, 0);
  rb_define_module_function(mWin, 'get_key_state', @Win_get_key_state, 1);
  rb_define_module_function(mWin, 'set_cursor', @Win_set_cursor, 1);
  rb_define_module_function(mWin, 'load_cursor', @Win_load_cursor, 1);
  rb_define_module_function(mWin, 'shell_execute', @Win_shell_execute, 6);
  rb_define_module_function(mWin, 'keybd_event', @Win_keybd_event, 4);
  rb_define_module_function(mWin, 'get_computer_name', @Win_get_computer_name, 0);
  rb_define_module_function(mWin, 'create_class_id', @Win_create_class_id, 0);
end;

exports
  ap_mWin;

end.
