unit uUpDown;

interface

uses Rubies, ComCtrls;

var
  cUpDown: Tvalue;

function ap_cUpDown: Tvalue;
procedure UpDown_setup(obj: Tvalue; real: TUpDown);
function UpDown_alloc(This: Tvalue; real: TUpDown): Tvalue;
procedure Init_UpDown;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cUpDown: Tvalue;
begin
  result := cUpDown;
end;

procedure UpDown_setup(obj: Tvalue; real: TUpDown);
begin
  AssignPropMethod(real, [Handle]);
end;

function UpDown_alloc(This: Tvalue; real: TUpDown): Tvalue;
begin
  result := ChildAlloc(This, real);
  UpDown_setup(result, real);
end;

function UpDown_alloc_v(var AControl): Tvalue;
begin
  result := UpDown_alloc(cUpDown, TUpDown(AControl));
end;

function UpDown_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TUpDown;
begin
  real := TUpDown.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  UpDown_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_UpDown;
begin
  cUpDown := DefineCompoClass(mPhi, TUpDown, cWinControl, UpDown_alloc_v);
  DefineSingletonMethod(cUpDown, 'new', UpDown_new);
  DefineAttrMethod_retval(cUpDown, 'on_changing');
end;


end.
