unit uTreeView;

interface

uses Rubies, QComCtrls;

var
  cTreeView: Tvalue;

function ap_cTreeView: Tvalue; stdcall;
procedure TreeView_setup(obj: Tvalue; real: TTreeView);
function TreeView_alloc(This: Tvalue; real: TTreeView): Tvalue; stdcall;
procedure Init_TreeView;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi, uIO,
  uSizeConstraints, uCanvas, uFont, uTreeNode,
  uComponent, uControl;

function ap_cTreeView: Tvalue; stdcall;
begin
  result := cTreeView;
end;

procedure TreeView_setup(obj: Tvalue; real: TTreeView);
begin
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  rb_iv_set(obj, '@items', TreeNodes_alloc(ap_cTreeNodes, real.Items));
  AssignPropMethod(real, [Handle]);
end;

function TreeView_alloc(This: Tvalue; real: TTreeView): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  TreeView_setup(result, real);
end;

function TreeView_alloc_v(var AControl): Tvalue;
begin
  result := TreeView_alloc(cTreeView, TTreeView(AControl));
end;

function TreeView_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
begin
  real := TTreeView.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  TreeView_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function TreeView_load(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.LoadFromFile(STR2CSTR(v));
    except
      on E: EFOpenError do
        ap_raise(ap_eIOError, E.message);
    end;
  T_DATA:
    begin
      ap_data_get_object(v, TStream, stream);
      real.LoadFromStream(stream);
    end;
  end;
  rb_iv_set(This, '@items', TreeNodes_alloc(cTreeNodes, real.Items));
  result := This;
end;

function TreeView_save(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    real.SaveToFile(STR2CSTR(v));
  T_DATA:
  begin
    ap_data_get_object(v, TStream, stream);
    real.SaveToStream(stream);
  end;
  end;
  result := v;
end;

function TreeView_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  node: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := real.Selected;
  if node = nil then
    result := Qnil
  else
    result := Tvalue(node.Data);
  ;
end;

function TreeView_set_selected(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTreeView;
  node: TTreeNode;
begin
  real := ap_data_get_struct(This);
  node := GetNode(v);
  real.Selected := node;
  result := v;
end;

procedure Init_TreeView;
begin
  cTreeView := DefineCompoClass(mPhi, TTreeView, cWinControl, TreeView_alloc_v);
  DefineSingletonMethod(cTreeView, 'new', TreeView_new);
  rb_define_method(cTreeView, 'load', @TreeView_load, 1);
  rb_define_method(cTreeView, 'save', @TreeView_save, 1);
  DefineAttrGet(cTreeView, 'selected', TreeView_get_selected);
  DefineAttrSet(cTreeView, 'selected', TreeView_set_selected);
  rb_define_attr(cTreeView, 'canvas', 1, 0);
  rb_define_attr(cTreeView, 'font', 1, 0);
  rb_define_attr(cTreeView, 'items', 1, 0);
  DefineAttrMethod_retval(cTreeView, 'on_changing');
  DefineAttrMethod_retval(cTreeView, 'on_expanding');
  DefineAttrMethod_retval(cTreeView, 'on_collapsing');
  DefineAttrMethod_retval(cTreeView, 'on_editing');
  DefineAttrMethod_retval(cTreeView, 'on_edited');
  DefineAttrMethod_retval(cTreeView, 'on_compare');
end;

exports
  ap_cTreeView,
  TreeView_alloc;

end.
