unit uTimer;

interface

uses Rubies, QExtCtrls;

var
  cTimer: Tvalue;

function ap_cTimer: Tvalue;
procedure Timer_setup(obj: Tvalue; real: TTimer);
function Timer_alloc(This: Tvalue; real: TTimer): Tvalue;
procedure Init_Timer;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cTimer: Tvalue;
begin
  result := cTimer;
end;

procedure Timer_setup(obj: Tvalue; real: TTimer);
begin
  AssignPropMethod(real, [Handle]);
end;

function Timer_alloc(This: Tvalue; real: TTimer): Tvalue;
begin
  result := ChildAlloc(This, real);
  Timer_setup(result, real);
end;

function Timer_alloc_v(var AComponent): Tvalue;
begin
  result := Timer_alloc(cTimer, TTimer(AComponent));
end;

function Timer_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTimer;
begin
  real := TTimer.Create(nil);
  result := CompoAlloc(This, real);
  Timer_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_Timer;
begin
  cTimer := DefineCompoClass(mPhi, TTimer, cComponent, Timer_alloc_v);
  DefineSingletonMethod(cTimer, 'new', Timer_new);
end;

exports
  ap_cTimer,
  Timer_alloc;

end.
