unit uThread;

interface

uses Rubies, Classes;

var
  cThread: Tvalue;

function ap_cThread: Tvalue;
function Thread_alloc(This: Tvalue; real: TThread): Tvalue;
procedure Init_Thread;

implementation

uses uAlloc, PhiThread, uIntern, uPhi, uStrUtils, uHandle, uProp;

function ap_cThread: Tvalue;
begin
  result := cThread;
end;

function Thread_alloc(This: Tvalue; real: TThread): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function Thread_new(This: Tvalue): Tvalue; cdecl;
var
  real: TPhiThread;
begin
  real := TPhiThread.Create(True);
  result := ObjAlloc(This, real);
  real.set_this(result);
  rb_obj_call_init(result, 0, nil);
  real.Resume;
end;

function Thread_get_priority(This: Tvalue): Tvalue; cdecl;
var
  real: TPhiThread;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.Priority));
end;

function Thread_set_priority(This, v: Tvalue): Tvalue; cdecl;
begin
  result := v;
end;

function Thread_alive_p(This: Tvalue): Tvalue; cdecl;
var
  real: TPhiThread;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.alive_p);
end;

function Thread_terminate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhiThread;
begin
  real := ap_data_get_struct(This);
  real.Terminate;
  result := Qnil;
end;

function Thread_sync(This: Tvalue): Tvalue; cdecl;
var
  real: TPhiThread;
begin
  real := ap_data_get_struct(This);
  real.SyncProc := rb_f_lambda;
  real.Sync;
  result := Qnil;
end;

procedure Init_Thread;
begin
  cThread := rb_define_class_under(mPhi, 'Thread', ap_cObject);

  rb_define_singleton_method(cThread, 'new', @Thread_new, 0);
  DefineAttrGet(cThread, 'priority', Thread_get_priority);
  DefineAttrSet(cThread, 'priority', Thread_set_priority);
  DefineAttrGet(cThread, 'alive?', Thread_alive_p);
  rb_define_method(cThread, 'terminate', @Thread_terminate, 0);
  rb_define_method(cThread, 'sync', @Thread_sync, 0);
  DefineAttrMethod(cThread, 'on_execute');
  rb_define_attr(cThread, 'canvas', 1, 0);
end;

exports
  ap_cThread,
  Thread_alloc;


end.
