unit uTabSheet;

interface

uses Rubies, QComCtrls;

var
  cTabSheet: Tvalue;

function ap_cTabSheet: Tvalue;
procedure TabSheet_setup(obj: Tvalue; real: TTabSheet);
function TabSheet_alloc(This: Tvalue; real: TTabSheet): Tvalue;
procedure Init_TabSheet;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cTabSheet: Tvalue;
begin
  result := cTabSheet;
end;

procedure TabSheet_setup(obj: Tvalue; real: TTabSheet);
begin
  ap_set_child_attr_module(obj);
  AssignPropMethod(real, [Handle]);
end;

function TabSheet_alloc(This: Tvalue; real: TTabSheet): Tvalue;
begin
  result := ChildAlloc(This, real);
  TabSheet_setup(result, real);
end;

function TabSheet_alloc_v(var AControl): Tvalue;
begin
  result := TabSheet_alloc(cTabSheet, TTabSheet(AControl));
end;

function TabSheet_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := TTabSheet.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ap_data_get_object(Pvalue(argv)^, TPageControl, PageControl);
  real.PageControl := PageControl;
  TabSheet_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function TabSheet_get_page_control(This: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  PageControl := real.PageControl;
  if PageControl = nil then
    result := Qnil
  else
    result := PageControl.tag
  ;
end;

function TabSheet_set_page_control(This, v: Tvalue): Tvalue; cdecl;
var
  real: TTabSheet;
  PageControl: TPageControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPageControl, PageControl);
  real.PageControl := PageControl;
  result := v;
end;

procedure Init_TabSheet;
begin
  cTabSheet := DefineCompoClass(mPhi, TTabSheet, cWinControl, TabSheet_alloc_v);
  DefineSingletonMethod(cTabSheet, 'new', TabSheet_new);
  DefineAttrGet(cTabSheet, 'page_control', TabSheet_get_page_control);
  DefineAttrSet(cTabSheet, 'page_control', TabSheet_set_page_control);
end;

exports
  ap_cTabSheet,
  TabSheet_alloc;

end.
