unit uStatusBar;

interface

uses Rubies, QComCtrls;

var
  cStatusBar: Tvalue;

function ap_cStatusBar: Tvalue;
procedure StatusBar_setup(obj: Tvalue; real: TStatusBar);
function StatusBar_alloc(This: Tvalue; real: TStatusBar): Tvalue;
procedure Init_StatusBar;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cStatusBar: Tvalue;
begin
  result := cStatusBar;
end;

procedure StatusBar_setup(obj: Tvalue; real: TStatusBar);
begin
  AssignPropMethod(real, [Handle]);
end;

function StatusBar_alloc(This: Tvalue; real: TStatusBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  StatusBar_setup(result, real);
end;

function StatusBar_alloc_v(var AControl): Tvalue;
begin
  result := StatusBar_alloc(cStatusBar, TStatusBar(AControl));
end;

function StatusBar_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStatusBar;
begin
  real := TStatusBar.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  StatusBar_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_StatusBar;
begin
  cStatusBar := DefineCompoClass(mPhi, TStatusBar, cControl, StatusBar_alloc_v);
  DefineSingletonMethod(cStatusBar, 'new', StatusBar_new);
end;

exports
  ap_cStatusBar,
  StatusBar_alloc;

end.
