unit uSplitter;

interface

uses Rubies, QExtCtrls;

var
  cSplitter: Tvalue;
  
function ap_cSplitter: Tvalue; stdcall;
procedure Splitter_setup(obj: Tvalue; real: TSplitter);
function Splitter_alloc(This: Tvalue; real: TSplitter): Tvalue; stdcall;
procedure Init_Splitter;

implementation

uses
  Classes,
  uIntern, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cSplitter: Tvalue; stdcall;
begin
  result := cSplitter;
end;

procedure Splitter_setup(obj: Tvalue; real: TSplitter);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
end;

function Splitter_alloc(This: Tvalue; real: TSplitter): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Splitter_setup(result, real);
end;

function Splitter_alloc_v(var AControl): Tvalue;
begin
  result := Splitter_alloc(ap_cSplitter, TSplitter(AControl));
end;

function Splitter_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSplitter;
begin
  real := TSplitter.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Splitter_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_Splitter;
begin
  DefineConstSetType(mPhi, TypeInfo(TResizeStyle));
  cSplitter := DefineCompoClass(mPhi, TSplitter, cControl, Splitter_alloc_v);
  DefineSingletonMethod(cSplitter, 'new', Splitter_new);
end;

exports
  ap_cSplitter,
  Splitter_alloc;

end.
