unit uSpeedButton;

interface

uses Rubies, QButtons;

var
  cSpeedButton: Tvalue;

function ap_cSpeedButton: Tvalue; stdcall;
procedure SpeedButton_setup(obj: Tvalue; real: TSpeedButton);
function SpeedButton_alloc(This: Tvalue; real: TSpeedButton): Tvalue; stdcall;
procedure Init_SpeedButton;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cSpeedButton: Tvalue; stdcall;
begin
  result := cSpeedButton;
end;

procedure SpeedButton_setup(obj: Tvalue; real: TSpeedButton);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  AssignPropMethod(real, [Handle]);
end;

function SpeedButton_alloc(This: Tvalue; real: TSpeedButton): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  SpeedButton_setup(result, real);
end;

function SpeedButton_alloc_v(var AControl): Tvalue;
begin
  result := SpeedButton_alloc(cSpeedButton, TSpeedButton(AControl));
end;

function SpeedButton_new(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSpeedButton;
begin
  real := TSpeedButton.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  SpeedButton_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_SpeedButton;
begin
  cSpeedButton := DefineCompoClass(mPhi, TSpeedButton, cControl, SpeedButton_alloc_v);
  DefineSingletonMethod(cSpeedButton, 'new', SpeedButton_new);
end;

exports
  ap_cSpeedButton,
  SpeedButton_setup,
  SpeedButton_alloc;

end.
