unit uSizeConstraints;

interface

uses QControls, Rubies;

var
  cSizeConstraints: Tvalue;

function ap_cSizeConstraints: Tvalue; stdcall;
procedure SizeConstraints_setup(obj: Tvalue; real: TSizeConstraints);
function SizeConstraints_alloc(This: Tvalue; real: TSizeConstraints): Tvalue; stdcall;
procedure Init_SizeConstraints;

implementation

uses SysUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv;

function ap_cSizeConstraints: Tvalue; stdcall;
begin
  result := cSizeConstraints;
end;

procedure SizeConstraints_setup(obj: Tvalue; real: TSizeConstraints);
begin
  AssignPropMethod(real, [Handle]);
end;

function SizeConstraints_alloc(This: Tvalue; real: TSizeConstraints): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  SizeConstraints_setup(result, real);
end;

function SizeConstraints_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  Control: TControl;
  real: TSizeConstraints;
begin
  if argc <> 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
  ap_data_get_object(Pvalue(argv)^, TControl, Control);
  real := TSizeConstraints.Create(Control);
  result := ObjAlloc(This, real);
  SizeConstraints_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function SizeConstraints_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TSizeConstraints;
begin
  real := TSizeConstraints(ap_data_get_struct(This));
  with real do result := ap_String(Format(
    '#<%s: min_width=%d min_height=%d max_width=%d max_height=%d>', [dl_ClassName(This), MinWidth, MinHeight, MaxWidth, MaxHeight]));
end;

procedure Init_SizeConstraints;
begin
  cSizeConstraints := rb_define_class_under(mPhi, 'SizeConstraints', ap_cObject);
  DefineProp(cSizeConstraints, TSizeConstraints);

  DefineSingletonMethod(cSizeConstraints, 'new', SizeConstraints_new);
end;

exports
  ap_cSizeConstraints,
  SizeConstraints_alloc;

end.
