unit uSize;

interface

uses Types, Rubies;

var
  cSize: Tvalue;

function ap_cSize: Tvalue; stdcall;
function Size_alloc(This: Tvalue; real: TSize): Tvalue; stdcall;
procedure Init_Size;

implementation

uses SysUtils, uIntern, uAlloc, uPhi, uConv;

function ap_cSize: Tvalue; stdcall;
begin
  result := cSize;
end;

function Size_alloc(This: Tvalue; real: TSize): Tvalue; stdcall;
var
  p: PSize;
begin
  new(p);
  result := rb_data_object_alloc(This, p, nil, @ap_dispose);
  p^.cx := real.cx;
  p^.cy := real.cy;
end;

function Size_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  p: PSize;
begin
  SetLength(args, argc);
  args := argv;
  new(p);
  result := rb_data_object_alloc(This, p, nil, @ap_dispose);
  case argc of
  0:
    begin
      p^.cx := 0;
      p^.cy := 0;
    end;
  2:
    begin
      p^.cx := dl_Integer(args[0]);
      p^.cy := dl_Integer(args[1]);
    end;
  else
    ap_raise(ap_eArgError, sWrong_num_of_args);
  end;

  rb_obj_call_init(result, argc, argv);
end;

function Size_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TSize;
begin
  real := PSize(ap_data_get_struct(This))^;
  with real do result := ap_String(Format(
    '#<%s: cx=%d cy=%d>', [dl_ClassName(This), cx, cy]));
end;

function Size_set_cx(This, v: Tvalue): Tvalue; cdecl;
begin
  PSize(ap_data_get_struct(This))^.cx := dl_Integer(v);
  result := v;
end;

function Size_get_cx(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(PSize(ap_data_get_struct(This))^.cx);
end;

function Size_set_cy(This, v: Tvalue): Tvalue; cdecl;
begin
  PSize(ap_data_get_struct(This))^.cy := dl_Integer(v);
  result := v;
end;

function Size_get_cy(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(PSize(ap_data_get_struct(This))^.cy);
end;

procedure Init_Size;
begin
  cSize := rb_define_class_under(mPhi, 'Size', ap_cObject);
  DefineSingletonMethod(cSize, 'new', Size_new);
  DefineAttrSet(cSize, 'cx', Size_set_cx);
  DefineAttrGet(cSize, 'cx', Size_get_cx);
  DefineAttrSet(cSize, 'cy', Size_set_cy);
  DefineAttrGet(cSize, 'cy', Size_get_cy);
  DefineAttrGet(cSize, 'to_s', Size_to_s);
  rb_define_alias(cSize, 'width=', 'cx=');
  rb_define_alias(cSize, 'width', 'cx');
  rb_define_alias(cSize, 'height=', 'cy=');
  rb_define_alias(cSize, 'height', 'cy');
end;

exports
  ap_cSize,
  Size_alloc;

end.
