unit uShape;

interface

uses Rubies, QExtCtrls;

var
  cShape: Tvalue;

function ap_cShape: Tvalue;
procedure Shape_setup(obj: Tvalue; real: TShape);
function Shape_alloc(This: Tvalue; real: TShape): Tvalue;
procedure Init_Shape;

implementation

uses Classes, QGraphics,
  uIntern, uAlloc, uProp, uSizeConstraints,
  uComponent, uControl, uBrush, uPen, uPhi;

function ap_cShape: Tvalue;
begin
  result := cShape;
end;

procedure Shape_setup(obj: Tvalue; real: TShape);
begin
  rb_iv_set(obj, '@brush', Brush_alloc(cBrush, real.Brush));
  rb_iv_set(obj, '@pen', Pen_alloc(cPen, real.Pen));
end;

function Shape_alloc(This: Tvalue; real: TShape): Tvalue;
begin
  result := TmpAlloc(This, real);
  Shape_setup(result, real);
end;

function Shape_alloc_v(var AControl): Tvalue;
begin
  result := Shape_alloc(ap_cShape, TShape(AControl));
end;

function Shape_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TShape;
begin
  real := TShape.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Shape_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_Shape;
begin
  DefineConstSetType(mPhi, TypeInfo(TShapeType));
  cShape := DefineCompoClass(mPhi, TShape, cControl, Shape_alloc_v);
  DefineSingletonMethod(cShape, 'new', Shape_new);
end;

exports
  ap_cShape,
  Shape_alloc;



end.
