unit uSearchRec;

(*
  by take_tk 2001-04-06
  ap-list:1414
*)

interface

uses Rubies;

var
  sSearchRec: Tvalue;

procedure Init_SearchRec;

implementation

uses uDateTime, uConv, SysUtils, uStrUtils, uWin;

function SearchRec_alloc(real: TSearchRec): Tvalue;
var
  args: array of Tvalue;
  time:TDateTime;
begin
  SetLength(args, 4);
      //	protect from invalid file date like ..
      //	c:\save2dsk.bin 1980/00/00 00:00:00
  //args[0] := INT2FIX(real.Time);          //Time: Integer;
  try
    time := FileDateToDateTime(real.Time);
  except
    time := encodeDate(1900,1,1);
  end;
  args[0] := ap_DateTime(time);
    //
  args[1] := INT2FIX(real.Size);            //Size: Integer;
  args[2] := INT2FIX(real.Attr);            //Attr: Integer;
  args[3] := ap_String(real.Name);          //Name: TFileName;
  
  // not support
  //args[4] := INT2FIX(real.ExcludeAttr);   //ExcludeAttr: Integer;
  //args[5] := INT2FIX(real.FindHandle);    //FindHandle: THandle;
  //                                        //FindData: TWin32FindData;
  result := ap_struct_new(sSearchRec, args);
end;

(*
: Win.dos_dir(mask, attr)
  fBNg Win::SearchRec ̔zԂ܂B

  "Win.dos_dir" searches disignated directory by "mask" and "attr", and returns an array of SearchRec(s).

  mask  'c:/windows/*.*' ƂŎw肵܂B
  '\' ŋ؂邱Ƃł܂CRuby ŏꍇɂ '\\' ̂悤ɃGXP[vKvł傤B

  mask is like this; 'c:/windows/*.*'. You may use '\\' for delimtters.

  attr ɂ͎̎w肪\łB( Dos/Windows ̎dlƂ͈قȂ̂Œ )

  attr is differ from the same of Dos/Windows.  When "Win::FA_FILE" was designated, dos_dir choose files which have not faDirectory bit nor faVolumeID bit. Default is "Win::FA_ANY_FILE" which matches all.

      Win::FA_ANY_FILE      ׂ ( ftHg )
      Win::FA_FILE          t@C
      Win::FA_DIRECROY      fBNg
      Win::FA_VAOLUME_ID    {[x (  ? )

  * ȉ̎w͖łB
      Win::FA_READ_ONLY     ǂ݂Ƃp
      Win::FA_HIDDEN        B
    Oɂ͓ǂ݂Ƃ Win::SearchRec#attr 𒲂ׂĂB

  * Win::FA_FILE  Dos/Windows ̎dlɂ͂܂B
      Win::FA_FILE          not (FA_DIRECROTY or FA_VOLUME_ID)

  * ȉ͎wł܂Cŋ߂ Windows ł͖̂悤łB
      Win::FA_VAOLUME_ID {[xɃ}b`

  擾 Win::SearchRec#attr ͎̒萔ŔfĂB
    Win::FA_READ_ONLY
    Win::FA_HIDDEN
    Win::FA_SYS_FILE
    Win::FA_VOLUME_ID
    Win::FA_DIRECTORY
    Win::FA_ARCHIVE
    Win::FA_ANY_FILE

*)

const
  faFile = faAnyFile + 1;
  faDirVol = faDirectory or faVolumeID;

function Win_dos_dir(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  stat: Tvalue;
  mask: string;
  info: TSearchRec;
  attr: Integer;
  TimeFrom, TimeTo: TDateTime;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  mask := dl_String(args[0]);

  if ( argc > 1 ) and ( args[1] <> Qnil ) then
    attr := FIX2INT(args[1])
  else
    attr := faAnyFile;

  if ( argc > 2 ) and ( args[2] <> Qnil ) then
    TimeFrom := DateTimeToFileDate(dl_DateTime(args[2]))
  else
    TimeFrom := 0;

  if ( argc > 3 ) and ( args[3] <> Qnil ) then
    TimeTo := DateTimeToFileDate(dl_DateTime(args[3]))
  else
    TimeTo := 0;

  result := rb_ary_new;

  if FindFirst(mask, faAnyFile, info) = 0 then
  try
    repeat
      if ( attr = faAnyFile )
      or ( ( ( attr and faFile ) <> 0 ) and ( (info.attr and faDirVol) = 0 )
      or ( ( info.attr and attr ) <> 0 ) )
      then begin
        if  ( (info.attr and faDirVol) <> 0 )
        or  ( ( ( TimeFrom = 0 ) or ( info.time >= TimeFrom ) )
          and ( ( TimeTo   = 0 ) or ( info.time <= TimeTo ) ) )
        then begin
          stat := SearchRec_alloc(info);
          rb_ary_push(result, stat);
        end;
      end;
    until FindNext(info) <> 0;
  finally
    FindClose(info);
  end;
end;

procedure Init_SearchRec;
var
  args: array of PChar;
begin
    //Time: Integer;
    //Size: Integer;
    //Attr: Integer;
    //Name: TFileName;
    //ExcludeAttr: Integer;
    //FindHandle: THandle;
    //FindData: TWin32FindData;
  SetLength(args, 5);
  args[0] := PChar(LowerCase1('Time'));
  args[1] := PChar(LowerCase1('Size'));
  args[2] := PChar(LowerCase1('Attr'));
  args[3] := PChar(LowerCase1('Name'));
  args[4] := nil;
  sSearchRec := ap_struct_define('SearchRec', args);
  rb_global_variable(@sSearchRec);

    //faReadOnly    $00000001   ǂݏopt@C
    //faHidden      $00000002   \t@C
    //faSysFile     $00000004   VXet@C
    //faVolumeID    $00000008   {[t@C
    //faDirectory   $00000010   fBNgt@C
    //faArchive     $00000020   A[JCut@C
    //faAnyFile     $0000003F   ׂẴt@C
    //faFile        $00000040   t@C # Apollo extension
  ap_define_const(mWin, 'faReadOnly', INT2FIX(faReadOnly));
  ap_define_const(mWin, 'faHidden', INT2FIX(faHidden));
  ap_define_const(mWin, 'faSysFile', INT2FIX(faSysFile));
  ap_define_const(mWin, 'faVolumeID', INT2FIX(faVolumeID));
  ap_define_const(mWin, 'faDirectory', INT2FIX(faDirectory));
  ap_define_const(mWin, 'faArchive', INT2FIX(faArchive));
  ap_define_const(mWin, 'faAnyFile', INT2FIX(faAnyFile));
  ap_define_const(mWin, 'faFile', INT2FIX(faFile));

  DefineModuleFunction(mWin, 'dos_dir', Win_dos_dir);
end;

end.
