unit uScrollBox;

interface

uses Rubies, QForms;

var
  cScrollBox: Tvalue;
  
function ap_cScrollBox: Tvalue;
procedure ScrollBox_setup(obj: Tvalue; real: TScrollBox);
function ScrollBox_alloc(This: Tvalue; real: TScrollBox): Tvalue;
procedure Init_ScrollBox;

implementation

uses Classes,
  uIntern, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cScrollBox: Tvalue;
begin
  result := cScrollBox;
end;

procedure ScrollBox_setup(obj: Tvalue; real: TScrollBox);
begin
  ap_set_child_attr_module(obj);
end;

function ScrollBox_alloc(This: Tvalue; real: TScrollBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  ScrollBox_setup(result, real);
end;

function ScrollBox_alloc_v(var AControl): Tvalue;
begin
  result := ScrollBox_alloc(ap_cScrollBox, TScrollBox(AControl));
end;

function ScrollBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TScrollBox;
begin
  real := TScrollBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ScrollBox_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_ScrollBox;
begin
  cScrollBox := DefineCompoClass(mPhi, TScrollBox, cWinControl, ScrollBox_alloc_v);
  DefineSingletonMethod(cScrollBox, 'new', ScrollBox_new);
end;

exports
  ap_cScrollBox,
  ScrollBox_alloc;


end.
