unit uScrollBar;

interface

uses Rubies, QForms, QStdCtrls;

var
  cScrollBar: Tvalue;

function ap_cScrollBar: Tvalue; stdcall;
procedure ScrollBar_setup(obj: Tvalue; real: TScrollBar);
function ScrollBar_alloc(This: Tvalue; real: TScrollBar): Tvalue; stdcall;
procedure Init_ScrollBar;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cScrollBar: Tvalue; stdcall;
begin
  result := cScrollBar;
end;

procedure ScrollBar_setup(obj: Tvalue; real: TScrollBar);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  AssignPropMethod(real, [Handle]);
end;

function ScrollBar_alloc(This: Tvalue; real: TScrollBar): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  ScrollBar_setup(result, real);
end;

function ScrollBar_alloc_v(var AControl): Tvalue;
begin
  result := ScrollBar_alloc(cScrollBar, TScrollBar(AControl));
end;

function ScrollBar_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TScrollBar;
begin
  real := TScrollBar.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ScrollBar_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function ScrollBar_set_kind(This, v: Tvalue): Tvalue; cdecl;
var
  real: TScrollBar;
begin
  real := ap_data_get_struct(This);
  real.Kind := TScrollBarKind(FIX2INT(v));
  result := v;
end;

function ScrollBar_get_kind(This: Tvalue): Tvalue; cdecl;
var
  real: TScrollBar;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.Kind));
end;

procedure Init_ScrollBar;
begin
  cScrollBar := DefineCompoClass(mPhi, TScrollBar, cWinControl, ScrollBar_alloc_v);
  DefineSingletonMethod(cScrollBar, 'new', ScrollBar_new);
  DefineAttrSet(cScrollBar, 'kind', ScrollBar_set_kind);
  DefineAttrGet(cScrollBar, 'kind', ScrollBar_get_kind);
end;

exports
  ap_cScrollBar,
  ScrollBar_alloc;

end.
