unit uScreen;

interface

uses QForms, Rubies;

var
  cScreen: Tvalue;
  vScreen: Tvalue;

function ap_cScreen: Tvalue; stdcall;
function ap_vScreen: Tvalue; stdcall;
procedure Init_Screen;

implementation

uses uAlloc, uProp, uPhi, uStrings;

function ap_cScreen: Tvalue; stdcall;
begin
  result := cScreen;
end;

function ap_vScreen: Tvalue; stdcall;
begin
  result := vScreen;
end;

function Screen_get_height(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.height);
end;

function Screen_get_width(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.width);
end;

function Screen_get_cursor(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.cursor);
end;

function Screen_get_active_control(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := real.ActiveControl.tag;
end;

function Screen_get_active_form(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := real.ActiveForm.tag;
end;

function Screen_set_cursor(This, v: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  real.cursor := FIX2INT(v);
  result := v;
end;

function Screen_get_cursors(This, index: Tvalue): Tvalue; cdecl;
begin
  result := index;
end;

function Screen_set_cursors(This, index, cur: Tvalue): Tvalue; cdecl;
begin
  result := cur;
end;

function Screen_get_forms(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
  I: Integer;
  obj: Tvalue;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  for I := 0 to real.FormCount-1 do
  begin
    obj := real.Forms[I].tag;
    if obj = 0 then Continue;
    rb_ary_push(result, obj);
  end;
end;

function Screen_get_form_count(This: Tvalue): Tvalue; cdecl;
var
  real: TScreen;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.FormCount);
end;

function Screen_instance(This: Tvalue): Tvalue; cdecl;
begin
  result := vScreen;
end;

procedure Regist_Screen;
var
  real: TScreen;
  obj, module: Tvalue;
begin
  real := Screen;
  obj := ChildAlloc(cScreen, real);
  vScreen := obj;
  rb_define_const(mPhi, 'SCREEN', obj);
  rb_iv_set(obj, '@fonts', Strings_alloc(cStrings, real.Fonts));

  module := rb_module_new;
  rb_extend_object(obj, module);
  rb_iv_set(obj, '@child_attr_module', module);
end;

procedure Init_Screen;
begin
  cScreen := rb_define_class_under(mPhi, 'Screen', ap_cObject);
  DefineProp(cScreen, TScreen);

  rb_undef_method(CLASS_OF(cScreen), 'new');
  rb_define_singleton_method(cScreen, 'instance', @Screen_instance, 0);

  DefineAttrGet(cScreen, 'height', Screen_get_height);
  DefineAttrGet(cScreen, 'width', Screen_get_width);

  DefineAttrGet(cScreen, 'active_control', Screen_get_active_control);
  DefineAttrGet(cScreen, 'active_form', Screen_get_active_form);
  DefineAttrGet(cScreen, 'cursor', Screen_get_cursor);
  DefineAttrSet(cScreen, 'cursor', Screen_set_cursor);
  rb_define_method(cScreen, 'get_cursors', @Screen_get_cursors, 1);
  rb_define_method(cScreen, 'set_cursors', @Screen_set_cursors, 2);
  DefineAttrGet(cScreen, 'forms', Screen_get_forms);
  DefineAttrGet(cScreen, 'form_count', Screen_get_form_count);
  rb_define_attr(cScreen, 'fonts', 1, 0);
  rb_define_attr(cScreen, 'imes', 1, 0);
  rb_define_attr(cScreen, 'default_ime', 1, 0);

  Regist_Screen;
end;

exports
  ap_cScreen,
  ap_vScreen;

end.
