unit uRichEdit;

interface

uses Rubies, ComCtrls;

var
  cRichEdit: Tvalue;

function ap_cRichEdit: Tvalue;
procedure RichEdit_setup(obj: Tvalue; real: TRichEdit);
function RichEdit_alloc(This: Tvalue; real: TRichEdit): Tvalue;
procedure Init_RichEdit;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uStrings, uFont, uEdit,
  uComponent, uControl;

function ap_cRichEdit: Tvalue;
begin
  result := cRichEdit;
end;

procedure RichEdit_setup(obj: Tvalue; real: TRichEdit);
begin
  rb_iv_set(obj, '@lines', Strings_alloc(ap_cStrings, real.Lines));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [Handle]);
end;

function RichEdit_alloc(This: Tvalue; real: TRichEdit): Tvalue;
begin
  result := ChildAlloc(This, real);
  RichEdit_setup(result, real);
end;

function RichEdit_alloc_v(var AControl): Tvalue;
begin
  result := RichEdit_alloc(cRichEdit, TRichEdit(AControl));
end;

function RichEdit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := TRichEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  RichEdit_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function RichEdit_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := Qnil;
end;

function RichEdit_set_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Text := STR2CSTR(v);
  result := v;
end;

function RichEdit_get_text(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.Text));
end;

procedure Init_RichEdit;
begin
  cRichEdit := DefineCompoClass(mPhi, TRichEdit, cEdit, RichEdit_alloc_v);
  DefineSingletonMethod(cRichEdit, 'new', RichEdit_new);
  rb_define_method(cRichEdit, 'clear', @RichEdit_clear, 0);
  DefineAttrGet(cRichEdit, 'text', RichEdit_get_text);
  DefineAttrSet(cRichEdit, 'text', RichEdit_set_text);
end;

exports
  ap_cRichEdit,
  RichEdit_alloc;


end.
