unit uRadioGroup;

interface

uses Rubies, QExtCtrls;

var
  cradioGroup: Tvalue;

function ap_cRadioGroup: Tvalue; stdcall;
procedure RadioGroup_setup(obj: Tvalue; real: TRadioGroup);
function RadioGroup_alloc(This: Tvalue; real: TRadioGroup): Tvalue; stdcall;
procedure Init_RadioGroup;

implementation

uses
  Classes,
  uIntern, uAlloc, uProp, uPhi,
  uSizeConstraints, uStrings,
  uComponent, uControl, uGroupBox;

function ap_cRadioGroup: Tvalue; stdcall;
begin
  result := cRadioGroup;
end;

procedure RadioGroup_setup(obj: Tvalue; real: TRadioGroup);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@items', Strings_alloc(ap_cStrings, real.Items));
  ap_set_child_attr_module(obj);
end;

function RadioGroup_alloc(This: Tvalue; real: TRadioGroup): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  RadioGroup_setup(result, real);
end;

function RadioGroup_alloc_v(var AControl): Tvalue;
begin
  result := RadioGroup_alloc(cRadioGroup, TRadioGroup(AControl));
end;

function RadioGroup_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TRadioGroup;
begin
  real := TRadioGroup.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  RadioGroup_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_RadioGroup;
begin
  cRadioGroup := DefineCompoClass(mPhi, TRadioGroup, cGroupBox, RadioGroup_alloc_v);
  DefineSingletonMethod(cRadioGroup, 'new', RadioGroup_new);
end;

exports
  ap_cRadioGroup,
  RadioGroup_alloc;

end.
