unit uRadioButton;

interface

uses Rubies, QStdCtrls;

var
  cRadioButton: Tvalue;

function ap_cRadioButton: Tvalue; stdcall;
procedure RadioButton_setup(obj: Tvalue; real: TRadioButton);
function RadioButton_alloc(This: Tvalue; real: TRadioButton): Tvalue; stdcall;
procedure Init_RadioButton;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl, uButton;

function ap_cRadioButton: Tvalue; stdcall;
begin
  result := cRadioButton;
end;

procedure RadioButton_setup(obj: Tvalue; real: TRadioButton);
begin
  AssignPropMethod(real, [Handle]);
end;

function RadioButton_alloc(This: Tvalue; real: TRadioButton): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  RadioButton_setup(result, real);
end;

function RadioButton_alloc_v(var AControl): Tvalue;
begin
  result := RadioButton_alloc(ap_cRadioButton, TRadioButton(AControl));
end;

function RadioButton_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TRadioButton;
begin
  real := TRadioButton.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  RadioButton_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function RadioButton_set_caption(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRadioButton;
begin
  real := ap_data_get_struct(This);
  real.caption := STR2CSTR(v);
  result := v;
end;

procedure Init_RadioButton;
begin
  cRadioButton := DefineCompoClass(mPhi, TRadioButton, cButton, RadioButton_alloc_v);
  DefineSingletonMethod(cRadioButton, 'new', RadioButton_new);
  DefineAttrSet(cRadioButton, 'caption', RadioButton_set_caption);
end;

exports
  ap_cRadioButton,
  RadioButton_alloc;


end.
