unit uProp;

interface

uses Classes, TypInfo, Rubies;

function GetEnumName0(TypeInfo: PTypeInfo; v: Integer): string; stdcall;
function GetEnumProp0(obj: TObject; PropInfo: PPropInfo): string; stdcall;
function GetSetProp0(obj: TObject; PropInfo: PPropInfo; Brackets: Boolean): string; stdcall;
function GetEnumProp1(obj: TObject; const PropName: string): string; stdcall;
function GetSetProp1(obj: TObject; const PropName: string; Brackets: Boolean): string; stdcall;
function ap_get_str_prop(obj: TObject; const PropName: string; c: Char): Tvalue; stdcall;

procedure DefineAttrMethod(klass: Tvalue; name: PChar); stdcall;
procedure DefineAttrMethod_retval(klass: Tvalue; name: PChar); stdcall;
procedure DefineModuleAttrMethod(module: Tvalue; name: PChar); stdcall;

procedure AssignPropMethod(Obj: TObject; Handles: array of TObject); stdcall;
procedure DefineProp(cClass: Tvalue; AClass: TClass); stdcall;
procedure DefineConstSetType(module: Tvalue; TypeInfo: PTypeInfo); stdcall;

implementation

uses
  Types, SysUtils, uStrUtils,
  uHandle, uPhi, uError, uDebug, uIO, uConv,
  uPropInfo, uTypeInfo;

function Prop_set_boolean(This, v: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  try
    SetOrdProp(real, chopUnder(name), Ord(RTEST(v)));
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(E.message));
  end;
  result := v;
end;

function Prop_get_boolean(This: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  result := ap_bool(Boolean(GetOrdProp(real, trimUnder(name))));
end;

function Prop_set_integer(This, v: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  try
    SetOrdProp(real, chopUnder(name), NUM2INT(v));
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(E.message));
  end;
  result := v;
end;

function Prop_get_integer(This: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  result := rb_int2inum(GetOrdProp(real, trimUnder(name)));
end;

function Prop_set_float(This, v: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  try
    SetFloatProp(real, chopUnder(name), NUM2DBL(v));
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(E.message));
  end;
  result := v;
end;

function Prop_get_float(This: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  result := rb_float_new(GetFloatProp(real, trimUnder(name)));
end;

function Prop_set_set(This, v: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  try
    SetOrdProp(real, chopUnder(name), dl_ary_to_set(v));
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(E.message));
  end;
  result := v;
end;

function Prop_get_set(This: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
  v: Integer;
  i: Integer;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  result := rb_ary_new;
  v := GetOrdProp(real, trimUnder(name));
  i := 0;
  while v <> 0 do
  begin
    if v mod 2 = 1 then
      rb_ary_push(result, INT2FIX(i));
    v := v div 2;
    Inc(i);
  end;
end;

function Prop_set_string(This, v: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
  real_name, real_cstr: string;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  real_name := chopUnder(name);
  real_cstr := STR2CSTR(v);
  try
    SetStrProp(real, real_name, real_cstr);
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(E.message));
  end;
  result := v;
end;

function Prop_get_string(This: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
  real_name, S: string;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  real_name := trimUnder(name);
  S := GetStrProp(real, trimUnder(name));
  result := rb_str_new2(PChar(S));
end;

function Prop_set_object(This, v: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
  objv: TObject;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  objv := ap_data_get_struct(v);
  try
    SetObjectProp(real, chopUnder(name), objv);
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(E.message));
  end;
  if objv is TComponent then
    TComponent(objv).tag := v // no effect.
  else
    rb_iv_set(This, PChar('@'+chop(name)), v)
  ;
  result := v;
end;

function Prop_get_object(This: Tvalue): Tvalue; cdecl;
var
  real: TObject;
  name: PChar;
  objv: TObject;
begin
  real := ap_data_get_struct(This);
  name := rb_id2name(rb_frame_last_func);
  objv := GetObjectProp(real, trimUnder(name));
  if objv is TComponent then
    result := TComponent(objv).tag
  else
    result := rb_iv_get(This, PChar('@'+name))
  ;
end;

function Prop_set_method(This, v: Tvalue): Tvalue; cdecl;
var
  hash, key: Tvalue;
  name: string;
begin
  hash := rb_iv_get(This, '@events');
  name := LowerCase1(rb_id2name(rb_frame_last_func));
  SetLength(name, Length(name)-1); // chop!
  key := INT2FIX(rb_intern(PChar(name)));
  rb_hash_aset(hash, key, v);

  result := v;
end;

function Prop_get_method(This: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

procedure DefineAttrMethod(klass: Tvalue; name: PChar); stdcall;
begin
  DefineAttrSet(klass, name, Prop_set_method);
  rb_define_method(klass, name, @retnil, -1);
end;

procedure DefineAttrMethod_retval(klass: Tvalue; name: PChar); stdcall;
begin
  DefineAttrSet(klass, name, Prop_set_method);
  rb_define_method(klass, name, @retval, -1);
end;

procedure DefineModuleAttrMethod(module: Tvalue; name: PChar); stdcall;
begin
  DefineModuleAttrSet(module, name, Prop_set_method);
  DefineModuleFunction(module, name, retnil);
end;

function GetEnumName0(TypeInfo: PTypeInfo; v: Integer): string; stdcall;
begin
  case TypeInfo^.Kind of
  tkInteger, tkChar, tkEnumeration, tkWChar:
    result := UpperCase1(GetEnumName(TypeInfo, v));
  else
    result := '';
  end;
end;

function GetEnumProp0(obj: TObject; PropInfo: PPropInfo): string; stdcall;
begin
  if PropInfo = nil then
    result := ''
  else
    result := GetEnumName0(PropInfo^.PropType^, GetOrdProp(obj, PropInfo));
end;

function GetEnumProp1(obj: TObject; const PropName: string): string; stdcall;
var
  PropInfo: PPropInfo;
begin
  PropInfo := GetPropInfo(obj, PropName);
  if PropInfo = nil then
    result := ''
  else
    result := GetEnumProp0(obj, PropInfo);
end;

function GetSetProp0(obj: TObject; PropInfo: PPropInfo; Brackets: Boolean): string; stdcall;
var
  S: TIntegerSet;
  TypeInfo: PTypeInfo;
  I: Integer;
begin
  Integer(S) := GetOrdProp(obj, PropInfo);
  TypeInfo := GetTypeData(PropInfo^.PropType^)^.CompType^;
  for I := 0 to SizeOf(Integer) * 8 - 1 do
    if I in S then
    begin
      if Result <> '' then
        Result := Result + ',';
      Result := Result + GetEnumName0(TypeInfo, I);
    end;
  if Brackets then
    Result := '[' + Result + ']';
end;

function GetSetProp1(obj: TObject; const PropName: string;
  Brackets: Boolean): string; stdcall;
begin
  Result := GetSetProp0(obj, GetPropInfo(obj, PropName), Brackets);
end;

function ap_get_str_prop(obj: TObject; const PropName: string; c: Char): Tvalue; stdcall;
var
  S: string;
begin
  S := GetStrProp(obj, PropName);
  if c <> #0 then S := AnsiQuotedStr(S, c);
  Result := ap_String(S);
end;

procedure AssignPropMethod(Obj: TObject; Handles: array of TObject); stdcall;
var
  ATypeInfo: PTypeInfo;
  APropList: TPropList;
  Count, i, j: Integer;
  ATypeData: PTypeData;
  APropInfo: TPropInfo;
  AMethod: TMethod;
  AHandle: TObject;
  name: ShortString;
begin
  ATypeInfo := PTypeInfo(Obj.ClassInfo);
  ATypeData := GetTypeData(ATypeInfo);
  Count := ATypeData^.PropCount;
  GetPropInfos(ATypeInfo, @APropList);

  for i := 0 to Count-1 do
  begin
    APropInfo := APropList[i]^;
    if APropInfo.PropType^^.Kind = tkMethod then
    begin
      AMethod := GetMethodProp(Obj, APropList[i]);
      if AMethod.Code = nil then
      begin
        ATypeInfo := APropInfo.PropType^;
        name := ATypeInfo^.Name;
        name := Copy(name, 2, Length(name)-6) + APropInfo.Name;
        for j := Low(Handles) to High(Handles) do
        begin
          AHandle := Handles[j];
          AMethod.Code := AHandle.MethodAddress(name);
          AMethod.Data := AHandle;
          if AMethod.Code = nil then
          else
          begin
            SetMethodProp(Obj, APropList[i], AMethod);
            Break;
          end;
        end;
        if debug_p then
          if AMethod.Code = nil then
            Stdout('no impl: '+Obj.ClassName+'#'+name+#10);
      end;
    end;
  end;
end;

procedure DefineProp(cClass: Tvalue; AClass: TClass); stdcall;
var
  ATypeInfo: PTypeInfo;
  APropList: TPropList;
  Count, i: Integer;
  ATypeData: PTypeData;
  APropInfo: TPropInfo;
  name: PChar;
  ary, defined_p: Tvalue;
  argc: Integer;
  args: array of Tvalue;
  Readable, Writable: Boolean;
begin
  argc := 1;
  SetLength(args, argc);
  args[0] := Qtrue;
  ary := rb_class_instance_methods(argc, @args, cClass);

  ATypeInfo := PTypeInfo(AClass.ClassInfo);
  ATypeData := GetTypeData(ATypeInfo);
  Count := ATypeData^.PropCount;
  GetPropInfos(ATypeInfo, @APropList);

  for i := 0 to Count-1 do
  begin
    APropInfo := APropList[i]^;
    ATypeData := GetTypeData(APropInfo.PropType^);

    name := PChar(LowerCase1(APropInfo.Name));
    if name = 'tag' then continue;

    Readable := APropInfo.GetProc <> nil;
    Writable := APropInfo.SetProc <> nil;

    { cClass#name method defined? }
    defined_p := rb_ary_includes(ary, rb_str_new2(name));
    if not RTEST(defined_p) then
    begin
    case APropInfo.PropType^^.Kind of
    tkInteger, tkChar, tkWChar:
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_integer);
        if Readable then DefineAttrGet(cClass, name, Prop_get_integer);
      end;
    tkEnumeration:
      if ATypeData^.BaseType^ = TypeInfo(Boolean) then
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_boolean);
        if Readable then
        begin
          DefineAttrGet(cClass, name, Prop_get_boolean);
          rb_define_alias(cClass, PChar(name+'?'), name);
        end;
      end
      else
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_integer);
        if Readable then DefineAttrGet(cClass, name, Prop_get_integer);
      end;
    tkSet:
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_set);
        if Readable then DefineAttrGet(cClass, name, Prop_get_set);
      end;
    tkFloat:
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_float);
        if Readable then DefineAttrGet(cClass, name, Prop_get_float);
      end;
    tkString, tkLString, tkWString:
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_string);
        if Readable then DefineAttrGet(cClass, name, Prop_get_string);
      end;
    tkClass:
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_object);
        if Readable then DefineAttrGet(cClass, name, Prop_get_object);
      end;
    tkMethod:
      begin
        if Writable then DefineAttrSet(cClass, name, Prop_set_method);
        if Readable then DefineMethod(cClass, name, retnil);
      end;
    end;

    end;
  end;
end;

procedure DefineConstSetType(module: Tvalue; TypeInfo: PTypeInfo); stdcall;
var
  TypeData: PTypeData;
  Value: Integer;
  P: ^ShortString;
  T: PTypeData;

  function ap_TypeDataType(real: PTypeInfo): Tvalue;
  begin
    result := rb_data_object_alloc(cTypeInfo, real, nil, nil);
    TypeInfo_setup_internal(result, real);
    TypeInfo_setup_TypeData(result, real);
  end;

begin
  rb_hash_aset(vTypeInfo, ap_String(string(TypeInfo^.Name)), ap_TypeDataType(TypeInfo));
  TypeData := GetTypeData(TypeInfo);
  T := GetTypeData(TypeData^.BaseType^);
  P := @T^.NameList;
  for Value := T^.MinValue to T^.MaxValue do
  begin
    ap_define_const(module, P^, INT2FIX(Value));
    Inc(Integer(P), Length(P^) + 1);
  end;
end;

exports
  DefineAttrMethod,
  DefineAttrMethod_retval,
  DefineModuleAttrMethod,

  GetEnumName0,
  GetEnumProp0,
  GetEnumProp1,
  GetSetProp0,
  GetSetProp1,
  ap_get_str_prop,

  AssignPropMethod,
  DefineProp,
  DefineConstSetType;

end.
