unit uPoint;

interface

uses Types, Rubies;

var
  cPoint: Tvalue;

function ap_cPoint: Tvalue; stdcall;
function Point_alloc(This: Tvalue; real: TPoint): Tvalue; stdcall;
procedure Init_Point;

implementation

uses SysUtils, uIntern, uAlloc, uProp, uPhi, uConv;

function ap_cPoint: Tvalue; stdcall;
begin
  result := cPoint;
end;

function Point_alloc(This: Tvalue; real: TPoint): Tvalue; stdcall;
var
  p: PPoint;
begin
  new(p);
  result := rb_data_object_alloc(This, p, nil, @ap_dispose);
  p^.x := real.x;
  p^.y := real.y;
end;

function Point_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  p: PPoint;
begin
  SetLength(args, argc);
  args := argv;
  new(p);
  result := rb_data_object_alloc(This, p, nil, @ap_dispose);
  case argc of
  0:
    begin
      p^.x := 0;
      p^.y := 0;
    end;
  2:
    begin
      p^.x := dl_Integer(args[0]);
      p^.y := dl_Integer(args[1]);
    end;
  else
    ap_raise(ap_eArgError, sWrong_num_of_args);
  end;

  rb_obj_call_init(result, argc, argv);
end;

function Point_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TPoint;
begin
  real := PPoint(ap_data_get_struct(This))^;
  with real do result := ap_String(Format(
    '#<%s: x=%d y=%d>', [dl_ClassName(This), x, y]));
end;

function Point_set_x(This, v: Tvalue): Tvalue; cdecl;
begin
  PPoint(ap_data_get_struct(This))^.x := dl_Integer(v);
  result := v;
end;

function Point_get_x(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(PPoint(ap_data_get_struct(This))^.x);
end;

function Point_set_y(This, v: Tvalue): Tvalue; cdecl;
begin
  PPoint(ap_data_get_struct(This))^.y := dl_Integer(v);
  result := v;
end;

function Point_get_y(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(PPoint(ap_data_get_struct(This))^.y);
end;

procedure Init_Point;
begin
  cPoint := rb_define_class_under(mPhi, 'Point', ap_cObject);
  DefineSingletonMethod(cPoint, 'new', Point_new);
  DefineAttrSet(cPoint, 'x', Point_set_x);
  DefineAttrGet(cPoint, 'x', Point_get_x);
  DefineAttrSet(cPoint, 'y', Point_set_y);
  DefineAttrGet(cPoint, 'y', Point_get_y);
  DefineAttrGet(cPoint, 'to_s', Point_to_s);
end;

exports
  ap_cPoint,
  Point_alloc;

end.
