unit uPicture;

interface

uses Rubies, QGraphics;

var
  cPicture: Tvalue;

function ap_cPicture: Tvalue; stdcall;
procedure Init_Picture;
function Picture_alloc(This: Tvalue; real: TPicture): Tvalue; stdcall;

implementation

uses Classes, uIntern, uAlloc, uProp, uPhi, uBitmap, uIcon;

function ap_cPicture: Tvalue; stdcall;
begin
  result := cPicture;
end;
(*
procedure Picture_setup(This: Tvalue; real: TPicture);
begin
  if @real.OnChange = nil then real.OnEnter := Handle.doEnter;
  if @real.OnProgress = nil then real.OnExit := Handle.doExit;
end;
*)
function Picture_alloc(This: Tvalue; real: TPicture): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
end;

function Picture_new(This: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := TPicture.Create;
  result := ObjAlloc(This, real);

  rb_obj_call_init(result, 0, nil);
end;

function Picture_load(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.LoadFromFile(STR2CSTR(v));
    except
      on E: EFOpenError do
        ap_raise(ap_eIOError, E.message);
      on E: EInvalidGraphic do
        ap_raise(ap_eIOError, E.message);
    end;
  end;
  result := This;
end;

function Picture_save(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.SaveToFile(STR2CSTR(v));
    except
      on E: EFCreateError do
        ap_raise(ap_eIOError, E.message);
    end;
  end;
  result := Qnil;
end;

function Picture_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := Qnil;
end;

function Picture_get_bitmap(This: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := ap_data_get_struct(This);
  result := Bitmap_alloc(cBitmap, real.Bitmap);
  rb_iv_set(result, '@owner', This);
end;

function Picture_set_bitmap(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
  bitmap: TBitmap;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TBitmap, bitmap);
  real.Bitmap := bitmap;
  result := v;
end;

function Picture_get_icon(This: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := ap_data_get_struct(This);
  result := Icon_alloc(cIcon, real.Icon);
end;

function Picture_set_icon(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
  icon: TIcon;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TIcon, icon);
  real.Icon := icon;
  result := v;
end;

function Picture_get_metafile(This: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function Picture_set_metafile(This, v: Tvalue): Tvalue; cdecl;
begin
  result := v;
end;

function Picture_get_graphic(This: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
  graphic: TGraphic;
begin
  real := ap_data_get_struct(This);
  result := Qnil;
  graphic := real.Graphic;
  if graphic is TBitmap then
    result := Bitmap_alloc(cBitmap, real.Bitmap)
  else
  if graphic is TIcon then
    result := Icon_alloc(cIcon, real.Icon)
(*
  else
  if real.Graphic is TMetafile then
    result := Metafile_alloc(cMetafile, real.Metafile)
*)
  ;
end;

function Picture_set_graphic(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
  graphic: TGraphic;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TGraphic, graphic);
  real.Graphic := graphic;
  result := v;
end;

function Picture_get_width(This: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Width);
end;

function Picture_get_height(This: Tvalue): Tvalue; cdecl;
var
  real: TPicture;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Height);
end;

procedure Init_Picture;
begin
  cPicture := rb_define_class_under(mPhi, 'Picture', ap_cObject);
  DefineProp(cPicture, TPicture);

  rb_define_singleton_method(cPicture, 'new', @Picture_new, 0);
  rb_define_method(cPicture, 'load', @Picture_load, 1);
  rb_define_method(cPicture, 'save', @Picture_save, 1);
  rb_define_method(cPicture, 'assign', @Picture_assign, 1);
  DefineAttrGet(cPicture, 'bitmap', Picture_get_bitmap);
  DefineAttrSet(cPicture, 'bitmap', Picture_set_bitmap);
  DefineAttrGet(cPicture, 'icon', Picture_get_icon);
  DefineAttrSet(cPicture, 'icon', Picture_set_icon);
  DefineAttrGet(cPicture, 'graphic', Picture_get_graphic);
  DefineAttrSet(cPicture, 'graphic', Picture_set_graphic);
  DefineAttrGet(cPicture, 'width',  Picture_get_width);
  DefineAttrGet(cPicture, 'height', Picture_get_height);
end;

exports
  ap_cPicture,
  Picture_alloc;

end.
