unit uPhi;

interface

uses Rubies;

var
  mPhi: Tvalue;
  vPhiComponents: Tvalue;

function ap_mPhi: Tvalue; stdcall;
procedure Init_phi_module;
function StringOrSymbolToStr(v: Tvalue): PChar; stdcall;

implementation

uses SysUtils;

function ap_mPhi: Tvalue; stdcall;
begin
  result := mPhi;
end;

procedure Init_phi_module;
begin
  mPhi := rb_define_module('Phi');

  vPhiComponents := rb_ary_new();
  rb_global_variable(@vPhiComponents);
end;

function StringOrSymbolToStr(v: Tvalue): PChar;
begin
  case RTYPE(v) of
  T_STRING: result := STR2CSTR(v);
  T_SYMBOL: result := rb_id2name(SYM2ID(v));
  else
    ap_raise(ap_eArgError,
      Format('%s %s (String or Symbol required)',
        [sWrong_arg_type, rb_class2name(CLASS_OF(v))]
      )
    );
    result := nil; // avoid warning
  end;
end;

exports
  ap_mPhi,
  StringOrSymbolToStr;

end.
