unit uPanel;

interface

uses Rubies, QExtCtrls;

var
  cPanel: Tvalue;
  
function ap_cPanel: Tvalue; stdcall;
procedure Panel_setup(obj: Tvalue; real: TPanel);
function Panel_alloc(This: Tvalue; real: TPanel): Tvalue; stdcall;
procedure Init_Panel;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cPanel: Tvalue; stdcall;
begin
  result := cPanel;
end;

procedure Panel_setup(obj: Tvalue; real: TPanel);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  ap_set_child_attr_module(obj);
  AssignPropMethod(real, [Handle]);
end;

function Panel_alloc(This: Tvalue; real: TPanel): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Panel_setup(result, real);
end;

function Panel_alloc_v(var AControl): Tvalue;
begin
  result := Panel_alloc(ap_cPanel, TPanel(AControl));
end;

function Panel_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPanel;
begin
  real := TPanel.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Panel_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_Panel;
begin
  cPanel := DefineCompoClass(mPhi, TPanel, cWinControl, Panel_alloc_v);
  DefineSingletonMethod(cPanel, 'new', Panel_new);
end;

exports
  ap_cPanel,
  Panel_alloc;

end.
