unit uPaintBox;

interface

uses Rubies, QExtCtrls;

var
  cPaintBox: Tvalue;

function ap_cPaintBox: Tvalue; stdcall;
procedure PaintBox_setup(obj: Tvalue; real: TPaintBox);
function PaintBox_alloc(This: Tvalue; real: TPaintBox): Tvalue; stdcall;
procedure Init_PaintBox;

implementation

uses Classes, QGraphics,
  uHandle, uIntern, uAlloc, uProp, uPhi,
  uComponent, uControl, uPicture, uCanvas;

function ap_cPaintBox: Tvalue; stdcall;
begin
  result := cPaintBox;
end;

procedure PaintBox_setup(obj: Tvalue; real: TPaintBox);
begin
  rb_iv_set(obj, '@canvas', Canvas_alloc(cCanvas, real.Canvas));
  AssignPropMethod(real, [Handle]);
end;

function PaintBox_alloc(This: Tvalue; real: TPaintBox): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  PaintBox_setup(result, real);
end;

function PaintBox_alloc_v(var AControl): Tvalue;
begin
  result := PaintBox_alloc(ap_cPaintBox, TPaintBox(AControl))
end;

function PaintBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPaintBox;
begin
  real := TPaintBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  PaintBox_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_PaintBox;
begin
  cPaintBox := DefineCompoClass(mPhi, TPaintBox, cControl, PaintBox_alloc_v);
  DefineSingletonMethod(cPaintBox, 'new', PaintBox_new);
  rb_define_attr(cPaintBox, 'canvas', 1, 0);
end;

exports
  ap_cPaintBox,
  PaintBox_alloc;

end.
