unit uPageControl;

interface

uses Rubies, QComCtrls;

var
  cPageControl: Tvalue;

function ap_cPageControl: Tvalue;
procedure PageControl_setup(obj: Tvalue; real: TPageControl);
function PageControl_alloc(This: Tvalue; real: TPageControl): Tvalue;
procedure Init_PageControl;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cPageControl: Tvalue;
begin
  result := cPageControl;
end;

procedure PageControl_setup(obj: Tvalue; real: TPageControl);
begin
  ap_set_child_attr_module(obj);
  AssignPropMethod(real, [Handle]);
end;

function PageControl_alloc(This: Tvalue; real: TPageControl): Tvalue;
begin
  result := ChildAlloc(This, real);
  PageControl_setup(result, real);
end;

function PageControl_alloc_v(var AControl): Tvalue;
begin
  result := PageControl_alloc(cPageControl, TPageControl(AControl));
end;

function PageControl_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
begin
  real := TPageControl.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  PageControl_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function PageControl_select_next_page(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
  GoForward: Boolean;
begin
  if argc > 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
  if argc = 1 then
    GoForward := RTEST(Pvalue(argv)^)
  else
    GoForward := True;
  real := ap_data_get_struct(This);
  real.SelectNextPage(GoForward);
  result := Qnil;
end;

function PageControl_find_next_page(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TPageControl;
  CurPage: TTabSheet;
  GoForward: Boolean;
  CheckTabVisible: Boolean;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  if argc > 3 then ap_raise(ap_eArgError, sWrong_num_of_args);
  SetLength(args, argc);
  args := argv;
  ap_data_get_object(args[0], TTabSheet, CurPage);
  if argc > 1 then
    GoForward := RTEST(args[1])
  else
    GoForward := True;
  if argc > 2 then
    CheckTabVisible := RTEST(args[2])
  else
    CheckTabVisible := True;
  real := ap_data_get_struct(This);
  real.FindNextPage(CurPage, GoForward, CheckTabVisible);
  result := Qnil;
end;

function PageControl_pages(This, i: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(i);
  result := Qnil;
  try
    result := real.Pages[n].tag;
  except
    on E: Exception do
      ap_raise(ap_eArgError, PChar(E.message));
  end;
end;

function PageControl_get_page_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPageControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.PageCount);
end;

procedure Init_PageControl;
begin
  DefineConstSetType(mPhi, TypeInfo(TTabStyle));
//  DefineConstSetType(mPhi, TypeInfo(TTabPosition));
  cPageControl := DefineCompoClass(mPhi, TPageControl, cWinControl, PageControl_alloc_v);
  DefineSingletonMethod(cPageControl, 'new', PageControl_new);
  DefineMethod(cPageControl, 'select_next_page', PageControl_select_next_page);
  DefineMethod(cPageControl, 'find_next_page', PageControl_find_next_page);
  rb_define_method(cPageControl, 'pages', @PageControl_pages, 1);
  DefineAttrGet(cPageControl, 'page_count', PageControl_get_page_count);
end;

exports
  ap_cPageControl,
  PageControl_alloc;


end.
