unit uMetafile;

interface

uses Rubies, Graphics;

var
  cMetafile: Tvalue;

function ap_cMetafile: Tvalue; stdcall;
function Metafile_alloc(This: Tvalue; real: TMetafile): Tvalue; stdcall;
procedure Init_Metafile;

implementation

uses Classes, uIntern, uAlloc, uProp, uPhi;

function ap_cMetafile: Tvalue; stdcall;
begin
  result := cMetafile;
end;

function Metafile_alloc(This: Tvalue; real: TMetafile): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
end;

function Metafile_new(This: Tvalue): Tvalue; cdecl;
var
  real: TMetafile;
begin
  real := TMetafile.Create;
  result := ObjAlloc(This, real);

  rb_obj_call_init(result, 0, nil);
end;

function Metafile_load(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMetafile;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.LoadFromFile(STR2CSTR(v));
    except
      on E: EFOpenError do
        ap_raise(ap_eIOError, E.message);
    end;
  T_DATA:
    try
      ap_data_get_object(v, TStream, stream);
      real.LoadFromStream(stream);
    except
      on E: EReadError do;
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
  result := This;
end;

function Metafile_save(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMetafile;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  case RTYPE(v) of
  T_STRING:
    try
      real.SaveToFile(STR2CSTR(v));
    except
      on E: EFCreateError do
        ap_raise(ap_eIOError, E.message);
    end;
  T_DATA:
    try
      ap_data_get_object(v, TStream, stream);
      real.SaveToStream(stream);
    except
      on E: EWriteError do;
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
  result := v;
end;

function Metafile_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMetafile;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

procedure Init_Metafile;
begin
  cMetafile := rb_define_class_under(mPhi, 'Metafile', ap_cObject);
  DefineProp(cMetafile, TMetafile);

  rb_define_singleton_method(cMetafile, 'new', @Metafile_new, 0);
  rb_define_method(cMetafile, 'load', @Metafile_load, 1);
  rb_define_method(cMetafile, 'save', @Metafile_save, 1);
  rb_define_method(cMetafile, 'assign', @Metafile_assign, 1);
end;

exports
  ap_cMetafile,
  Metafile_alloc;

end.

