unit uMenu;

interface

uses Rubies, QMenus;

var
  cMenu, cMainMenu, cPopupMenu: Tvalue;

function ap_cMainMenu: Tvalue; stdcall;
function ap_cPopupMenu: Tvalue; stdcall;
function MainMenu_alloc(This: Tvalue; real: TMainMenu): Tvalue; stdcall;
function PopupMenu_alloc(This: Tvalue; real: TPopupMenu): Tvalue; stdcall;
procedure Init_Menu;

implementation

uses
  SysUtils, uStrUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uComponent, uMenuItem;

{ Menu building functions }

procedure InitMenuItems(AMenu: TMenu; Items: array of TMenuItem);
var
  I: Integer;
begin
  for I := Low(Items) to High(Items) do
    AMenu.Items.Add(Items[I]);
end;

function NewMenu(Owner: TComponent; const AName: string; Items: array of TMenuItem): TMainMenu;
begin
  Result := TMainMenu.Create(Owner);
  Result.Name := AName;
  InitMenuItems(Result, Items);
end;

function NewPopupMenu(Owner: TComponent; const AName: string; Alignment: TPopupAlignment; AutoPopup: Boolean; Items: array of TMenuItem): TPopupMenu;
begin
  Result := TPopupMenu.Create(Owner);
  Result.Name := AName;
  Result.AutoPopup := AutoPopup;
  Result.Alignment := Alignment;
  InitMenuItems(Result, Items);
end;

function ap_cMainMenu: Tvalue; stdcall;
begin
  result := cMainMenu;
end;

procedure MainMenu_setup(obj: Tvalue; real: TMainMenu);
begin
  rb_iv_set(obj, '@items', MenuItem_alloc(cMenuItem, real.items));
  rb_iv_set(obj, '@merged', rb_ary_new());
  ap_set_child_attr_module(obj);
end;

function MainMenu_alloc(This: Tvalue; real: TMainMenu): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  MainMenu_setup(result, real);
end;

function MainMenu_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMainMenu;
begin
  real := TMainMenu.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  MainMenu_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure InitMenuParent(ceo: Tvalue; Items: array of TMenuItem);
var
  i: Integer;

  procedure SetParent(Item: TMenuItem);
  var
    This, obj: Tvalue;
    name: string;
    i: Integer;
  begin
    PhiObjectList.Extract(Item);
    This := item.parent.tag;
    obj := item.tag;
    name := LowerCase1(Item.name);
    SetParentAttr(obj, This, PChar(name));
    SetParentAttr(obj, ceo, PChar(name));
    rb_iv_set(obj, '@parent', ceo);
    for i := 0 to Item.Count - 1 do
      SetParent(Item[i]);
  end;

begin
  for i := Low(Items) to High(Items) do
    SetParent(Items[i]);
end;

function Phi_new_menu(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  ceo: Tvalue;
  parent: TComponent;
  aname: PChar;
  vtems: array of Tvalue;
  items: array of TMenuItem;
  ary: Tvalue;
  ptr: Pvalue;
  len: Integer;
  i: Integer;
  real: TMainMenu;
  item: TMenuItem;
  module: Tvalue;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  ceo := args[0];
  parent := ap_data_get_struct(ceo);
  aname := StringOrSymbolToStr(args[1]);
  ary := args[2];
  ptr := ap_ary_ptr(ary);
  len := ap_ary_len(ary);
  SetLength(items, len);
  SetLength(vtems, len);
  for i := 0 to len-1 do
  begin
    vtems[i] := ptr^;
    ap_data_get_object(ptr^, TMenuItem, item);
    items[i] := item;
    Inc(ptr);
  end;

  real := NewMenu(parent, aname, items);
  result := ChildAlloc(cMainMenu, real);

  MainMenu_setup(result, real);

  rb_iv_set(ceo, PChar('@'+aname), result);
  module := rb_iv_get(ceo, '@child_attr_module');
  rb_define_attr(module, aname, 1, 0);

  rb_iv_set(result, '@parent', ceo);
  InitMenuParent(ceo, items);
end;

function MainMenu_merge(This, item: Tvalue): Tvalue; cdecl;

  procedure loop_merge(This, item: Tvalue);
  var
    ary: Tvalue;
    ptr: Pvalue;
    len: Integer;
  begin
    if item = This then
      ap_raise(ap_eArgError, 'loop merge');

    ary := rb_iv_get(This, '@merged');
    ptr := ap_ary_ptr(ary);
    len := ap_ary_len(ary);
    while len > 0 do
    begin
      loop_merge(ptr^, item);
      Inc(ptr);
      Dec(len);
    end;
  end;

var
  real, menu: TMainMenu;
  ary, includes: Tvalue;
begin
  loop_merge(This, item);

  real := ap_data_get_struct(This);
  ap_data_get_object(item, TMainMenu, menu);
  ary := rb_iv_get(item, '@merged');
  includes := rb_ary_includes(ary, This);
  if not RTEST(includes) then rb_ary_push(ary, This);
  real.Merge(menu);

  result := Qnil;
end;

function MainMenu_unmerge(This, item: Tvalue): Tvalue; cdecl;
var
  real, menu: TMainMenu;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(item, TMainMenu, menu);
  rb_ary_delete(rb_iv_get(item, '@merged'), This);
  real.Unmerge(menu);

  result := Qnil;
end;

function ap_cPopupMenu: Tvalue; stdcall;
begin
  result := cPopupMenu;
end;

procedure PopupMenu_setup(This: Tvalue; real: TPopupMenu);
begin
  rb_iv_set(This, '@items', MenuItem_alloc(cMenuItem, real.items));
  ap_set_child_attr_module(This);
end;

function PopupMenu_alloc(This: Tvalue; real: TPopupMenu): Tvalue; stdcall;
begin
  result := ChildAlloc(cPopupMenu, real);
  PopupMenu_setup(result, real);
end;

function PopupMenu_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPopupMenu;
begin
  real := TPopupMenu.Create(nil);
  result := ChildAlloc(This, real);
  CompoSetup(argc, argv, real);
  PopupMenu_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function Phi_new_popup_menu(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  ceo: Tvalue;
  parent: TComponent;
  aname: PChar;
  vtems: array of Tvalue;
  items: array of TMenuItem;
  ary: Tvalue;
  ptr: Pvalue;
  len: Integer;
  i: Integer;
  real: TPopupMenu;
  module: Tvalue;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  ceo := args[0];
  parent := ap_data_get_struct(ceo);
  aname := StringOrSymbolToStr(args[1]);
  ary := args[2];
  ptr := ap_ary_ptr(ary);
  len := ap_ary_len(ary);
  SetLength(items, len);
  SetLength(vtems, len);
  for i := 0 to len-1 do
  begin
    vtems[i] := ptr^;
    items[i] := TMenuItem(ap_data_get_struct(ptr^));
    Inc(ptr);
  end;

  real := NewPopupMenu(parent, aname, paCenter, True, items);
  result := CompoAlloc(cMainMenu, real);

  PopupMenu_setup(result, real);

  rb_iv_set(ceo, PChar('@'+aname), result);
  module := rb_iv_get(ceo, '@child_attr_module');
  rb_define_attr(module, aname, 1, 0);

  rb_iv_set(result, '@parent', ceo);
  InitMenuParent(ceo, items);
end;

procedure Init_Menu;
begin
  DefineConstSetType(mPhi, TypeInfo(TMenuItemAutoFlag));

  cMenu := DefineCompoClass(mPhi, TMenu, cComponent, nil);

  cMainMenu := DefineCompoClass(mPhi, TMainMenu, cMenu, nil);
  DefineSingletonMethod(cMainMenu, 'new', MainMenu_new);
  DefineModuleFunction(mPhi, 'new_menu', Phi_new_menu);
  rb_define_method(cMainMenu, 'merge', @MainMenu_merge, 1);
  rb_define_method(cMainMenu, 'unmerge', @MainMenu_unmerge, 1);

  cPopupMenu := DefineCompoClass(mPhi, TPopupMenu, cMenu, nil);
  DefineSingletonMethod(cPopupMenu, 'new', PopupMenu_new);
  DefineModuleFunction(mPhi, 'new_popup_menu', Phi_new_popup_menu);
end;

exports
  ap_cMainMenu,
  MainMenu_alloc,
  ap_cPopupMenu,
  PopupMenu_alloc;

end.
