unit uMemo;

interface

uses Rubies, QStdCtrls;

var
  cMemo: Tvalue;

function ap_cMemo: Tvalue; stdcall;
procedure Memo_setup(obj: Tvalue; real: TMemo);
function Memo_alloc(This: Tvalue; real: TMemo): Tvalue; stdcall;
procedure Init_Memo;

implementation

uses
  Classes, uStrUtils,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont, uStrings,
  uComponent, uControl, uEdit;

function ap_cMemo: Tvalue; stdcall;
begin
  result := cMemo;
end;

procedure Memo_setup(obj: Tvalue; real: TMemo);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  rb_iv_set(obj, '@lines', Strings_alloc(ap_cStrings, real.Lines));
  AssignPropMethod(real, [Handle]);
end;

function Memo_alloc(This: Tvalue; real: TMemo): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Memo_setup(result, real);
end;

function Memo_alloc_v(var AControl): Tvalue;
begin
  result := Memo_alloc(cMemo, TMemo(AControl));
end;

function Memo_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := TMemo.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Memo_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function Memo_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := Qnil;
end;

function Memo_set_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  real.Text := STR2CSTR(v);
  result := v;
end;

function Memo_get_text(This: Tvalue): Tvalue; cdecl;
var
  real: TMemo;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(WideCharToString(PWideChar(real.Text))));
end;

procedure Init_Memo;
begin
  DefineConstSetType(mPhi, TypeInfo(TScrollStyle));
  cMemo := DefineCompoClass(mPhi, TMemo, cEdit, Memo_alloc_v);
  DefineSingletonMethod(cMemo, 'new', Memo_new);
  rb_define_method(cMemo, 'clear', @Memo_clear, 0);
  DefineAttrGet(cMemo, 'text', Memo_get_text);
  DefineAttrSet(cMemo, 'text', Memo_set_text);
end;

exports
  ap_cMemo,
  Memo_alloc;

end.
