unit uMaskEdit;

interface

uses Rubies, QMask;

var
  cMaskEdit: Tvalue;

function ap_cMaskEdit: Tvalue; stdcall;
procedure MaskEdit_setup(obj: Tvalue; real: TMaskEdit);
function MaskEdit_alloc(This: Tvalue; real: TMaskEdit): Tvalue; stdcall;
procedure Init_MaskEdit;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont,
  uComponent, uControl;

function ap_cMaskEdit: Tvalue; stdcall;
begin
  result := cMaskEdit;
end;

procedure MaskEdit_setup(obj: Tvalue; real: TMaskEdit);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [Handle]);
end;

function MaskEdit_alloc(This: Tvalue; real: TMaskEdit): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  MaskEdit_setup(result, real);
end;

function MaskEdit_alloc_v(var AControl): Tvalue;
begin
  result := MaskEdit_alloc(cMaskEdit, TMaskEdit(AControl));
end;

function MaskEdit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TMaskEdit;
begin
  real := TMaskEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  MaskEdit_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_MaskEdit;
begin
  cMaskEdit := DefineCompoClass(mPhi, TMaskEdit, cWinControl, MaskEdit_alloc_v);
  DefineSingletonMethod(cMaskEdit, 'new', MaskEdit_new);
end;

exports
  ap_cMaskEdit,
  MaskEdit_alloc;

end.
