unit uListView;

interface

uses Rubies, QComCtrls;

var
  cIconOptions, cListView: Tvalue;

function ap_cIconOptions: Tvalue;
function ap_cListView: Tvalue; stdcall;
function ListView_alloc(This: Tvalue; real: TListView): Tvalue; stdcall;
procedure Init_ListView;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi, uIO,
  uSizeConstraints, uCanvas, uFont, uListItem, uListColumn,
  uComponent, uControl;

function ap_cIconOptions: Tvalue;
begin
  result := cIconOptions;
end;

function ap_cListView: Tvalue; stdcall;
begin
  result := cListView;
end;

function IconOptions_alloc(This: Tvalue; real: TIconOptions): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

procedure ListView_setup(obj: Tvalue; real: TListView);
begin
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  rb_iv_set(obj, '@items', ListItems_alloc(ap_cListItems, real.Items));
  rb_iv_set(obj, '@columns', ListColumns_alloc(ap_cListColumns, real.Columns));
  AssignPropMethod(real, [Handle]);
end;

function ListView_alloc(This: Tvalue; real: TListView): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  ListView_setup(result, real);
end;

function ListView_alloc_v(var AControl): Tvalue;
begin
  result := ListView_alloc(cListView, TListView(AControl));
end;

function ListView_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TListView;
begin
  real := TListView.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ListView_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function ListView_get_selected(This: Tvalue): Tvalue; cdecl;
var
  real: TListView;
  item: TListItem;
begin
  real := ap_data_get_struct(This);
  item := real.Selected;
  if item = nil then
    result := Qnil
  else
    result := Tvalue(item.Data);
end;

procedure Init_ListView;
begin
  DefineConstSetType(mPhi, TypeInfo(TIconArrangement));
  DefineConstSetType(mPhi, TypeInfo(TItemChange));

  cIconOptions := rb_define_class_under(mPhi, 'IconOptions', ap_cObject);
  DefineProp(cIconOptions, TIconOptions);

  DefineConstSetType(mPhi, TypeInfo(TViewStyle));

  cListView := DefineCompoClass(mPhi, TListView, cWinControl, ListView_alloc_v);
  DefineAttrGet(cListView, 'selected', ListView_get_selected);
  rb_define_attr(cListView, 'items', 1, 0);

  DefineSingletonMethod(cListView, 'new', ListView_new);
  rb_define_attr(cListView, 'canvas', 1, 0);
  DefineAttrMethod_retval(cListView, 'on_changing');
  DefineAttrMethod_retval(cListView, 'on_measure_item');
  DefineAttrMethod_retval(cListView, 'on_column_click');
  DefineAttrMethod_retval(cListView, 'on_compare');
  DefineAttrMethod_retval(cListView, 'on_data_find');
  DefineAttrMethod_retval(cListView, 'on_edited');
  DefineAttrMethod_retval(cListView, 'on_editing');
  DefineAttrMethod_retval(cListView, 'on_get_sub_item_image');
  DefineAttrMethod_retval(cListView, 'on_info_tip');
end;

exports
  ap_cListView,
  ListView_alloc;

end.
