unit uListColumn;

interface

uses Rubies, QComCtrls;

var
  cListColumn, cListColumns: Tvalue;

function ap_cListColumn: Tvalue; stdcall;
function ap_cListColumns: Tvalue; stdcall;
function ListColumn_alloc(This: Tvalue; real: TListColumn): Tvalue; stdcall;
function ListColumns_alloc(This: Tvalue; real: TListColumns): Tvalue; stdcall;
procedure Init_ListColumn;

implementation

uses
  SysUtils, Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cListColumn: Tvalue; stdcall;
begin
  result := cListColumn;
end;

function ap_cListColumns: Tvalue; stdcall;
begin
  result := cListColumns;
end;

procedure ListColumn_setup(obj: Tvalue; real: TListColumn);
begin
//  real.tag := obj;
end;

function ListColumn_alloc(This: Tvalue; real: TListColumn): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  ListColumn_setup(result, real);
end;

function ListColumn_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TListColumn;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

procedure ListColumns_setup(obj: Tvalue; real: TListColumns);
begin
//
end;

function ListColumns_alloc(This: Tvalue; real: TListColumns): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  ListColumns_setup(result, real);
end;

function ListColumns_aref(This, index: Tvalue): Tvalue; cdecl;
var
  real: TListColumns;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(index);
  if (n < 0) or (real.Count <= n) then
    ap_raise(ap_eIndexError, sOut_of_range);

  result := ListColumn_alloc(cListColumn, real[n]);
end;

function ListColumns_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TListColumns;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Count);
end;

function ListColumns_get_owner(This: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function ListColumns_add(This: Tvalue): Tvalue; cdecl;
var
  real: TListColumns;
begin
  real := ap_data_get_struct(This);
  result := ListColumn_alloc(cListColumn, real.Add);
end;

function ListColumns_insert(This, index: Tvalue): Tvalue; cdecl;
var
  real: TListColumns;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(index);
  if (n < 0) or (real.Count < n) then
    ap_raise(ap_eIndexError, sOut_of_range);
  result := ListColumn_alloc(cListColumn, TListColumn(real.Insert(n)));
end;

function ListColumns_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TListColumns;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := Qnil;
end;

function ListColumns_update(This: Tvalue): Tvalue; cdecl;
var
  real: TListColumns;
begin
  real := ap_data_get_struct(This);
  real.BeginUpdate;
  try
    result := rb_yield(Qnil);
  finally
    real.EndUpdate;
  end;
end;

procedure Init_ListColumn;
begin
  cListColumn := rb_define_class_under(mPhi, 'ListColumn', ap_cObject);
  DefineProp(cListColumn, TListColumn);
  rb_define_method(cListColumn, 'assign', @ListColumn_assign, 1);

  cListColumns := rb_define_class_under(mPhi, 'ListColumns', ap_cObject);
  DefineProp(cListColumns, TListColumns);
  rb_define_method(cListColumns, '[]', @ListColumns_aref, 1);
  DefineAttrGet(cListColumns, 'count', ListColumns_get_count);
  DefineAttrGet(cListColumns, 'owner', ListColumns_get_owner);
  rb_define_method(cListColumns, 'add', @ListColumns_add, 0);
  rb_define_method(cListColumns, 'insert', @ListColumns_insert, 1);
  rb_define_method(cListColumns, 'clear', @ListColumns_clear, 0);
  rb_define_method(cListColumns, 'update', @ListColumns_update, 0);
end;

exports
  ap_cListColumn,
  ap_cListColumns,
  ListColumn_alloc,
  ListColumns_alloc;

end.
