unit uListBox;

interface

uses Rubies, QStdCtrls;

var
  cListBox: Tvalue;

function ap_cListBox: Tvalue; stdcall;
procedure ListBox_setup(obj: Tvalue; real: TListBox);
function ListBox_alloc(This: Tvalue; real: TListBox): Tvalue; stdcall;
procedure Init_ListBox;

implementation

uses
  Types, Classes, SysUtils,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uCanvas, uFont, uStrings, uRect,
  uComponent, uControl;

function ap_cListBox: Tvalue; stdcall;
begin
  result := cListBox;
end;

procedure ListBox_setup(obj: Tvalue; real: TListBox);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@canvas', Canvas_alloc(ap_cCanvas, real.Canvas));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  rb_iv_set(obj, '@items', Strings_alloc(ap_cStrings, real.Items));
  AssignPropMethod(real, [Handle]);
end;

function ListBox_alloc(This: Tvalue; real: TListBox): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  ListBox_setup(result, real);
end;

function ListBox_alloc_v(var AControl): Tvalue;
begin
  result := ListBox_alloc(cListBox, TListBox(AControl));
end;

function ListBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin
  real := TListBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ListBox_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function ListBox_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  real.Clear;
  result := Qnil;
end;

function ListBox_get_sel_count(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  result := INT2FIX(real.SelCount);
end;

function ListBox_item_at_pos(This, pos, existing: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ItemAtPos(PPoint(ap_data_get_struct(pos))^, RTEST(existing)));
end;

function ListBox_item_rect(This, index: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin;
  real := ap_data_get_struct(This);
  result := Qnil;
  try
    result := Rect_alloc(cRect, real.ItemRect(FIX2INT(index)));
  except
    on E: Exception do;
  end;
end;

function ListBox_get_item_index(This: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ItemIndex);
end;

function ListBox_set_item_index(This,v: Tvalue): Tvalue; cdecl;
var
  real: TListBox;
begin
  real := ap_data_get_struct(This);
  real.ItemIndex := FIX2INT(v);
  result := v;
end;

procedure Init_ListBox;
begin
  DefineConstSetType(mPhi, TypeInfo(TListBoxStyle));
  cListBox := DefineCompoClass(mPhi, TListBox, cWinControl, ListBox_alloc_v);
  DefineSingletonMethod(cListBox, 'new', ListBox_new);
  DefineAttrGet(cListBox, 'sel_count', ListBox_get_sel_count);
  rb_define_method(cListBox, 'clear', @ListBox_clear, 0);
  rb_define_method(cListBox, 'item_at_pos', @ListBox_item_at_pos , 2);
  rb_define_method(cListBox, 'item_rect', @ListBox_item_rect ,1);
  DefineAttrGet(cListBox, 'item_index', ListBox_get_item_index);
  DefineAttrSet(cListBox, 'item_index', ListBox_set_item_index);
  DefineAttrMethod_retval(cListBox, 'on_measure_item');
  rb_define_attr(cListBox, 'canvas', 1, 0);
end;

exports
  ap_cListBox,
  ListBox_alloc;


end.
