unit uLabel;

interface

uses Rubies, QStdCtrls;

var
  cLabel: Tvalue;

function ap_cLabel: Tvalue; stdcall;
function Label_alloc(This: Tvalue; real: TLabel): Tvalue; stdcall;
procedure Init_Label;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uCanvas, uFont,
  uComponent, uControl;

function ap_cLabel: Tvalue; stdcall;
begin
  result := cLabel;
end;

procedure Label_setup(obj: Tvalue; real: TLabel);
begin
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [Handle]);
end;

function Label_alloc(This: Tvalue; real: TLabel): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Label_setup(result, real);
end;

function Label_alloc_v(var AControl): Tvalue;
begin
  result := Label_alloc(cLabel, TLabel(AControl));
end;

function Label_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TLabel;
begin
  real := TLabel.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Label_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function Label_set_caption(This, v: Tvalue): Tvalue; cdecl;
var
  real: TLabel;
begin
  real := ap_data_get_struct(This);
  real.caption := STR2CSTR(v);
  result := v;
end;

procedure Init_Label;
begin
  DefineConstSetType(mPhi, TypeInfo(TTextLayout));
  cLabel := DefineCompoClass(mPhi, TLabel, cControl, Label_alloc_v);
  DefineSingletonMethod(cLabel, 'new', Label_new);
  DefineAttrSet(cLabel, 'caption', Label_set_caption);
  rb_define_attr(cLabel, 'canvas', 1, 0);
  rb_define_attr(cLabel, 'font', 1, 0);
end;

exports
  ap_cLabel,
  Label_alloc;


end.
