unit uImage;

interface

uses Rubies, QExtCtrls, QControls, QImglist;

var
  cImage, cImageList: Tvalue;

function ap_cImage: Tvalue; stdcall;
procedure Image_setup(obj: Tvalue; real: TImage);
function Image_alloc(This: Tvalue; real: TImage): Tvalue; stdcall;
function ap_cImageList: Tvalue; stdcall;
procedure Init_Image;

implementation

uses
  Classes, QGraphics,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uCanvas,
  uComponent, uControl, uPicture;

function ap_cImage: Tvalue; stdcall;
begin
  result := cImage;
end;

procedure Image_setup(obj: Tvalue; real: TImage);
begin
  rb_iv_set(obj, '@picture', Picture_alloc(cPicture, real.Picture));
  AssignPropMethod(real, [Handle]);
end;

function Image_alloc(This: Tvalue; real: TImage): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  Image_setup(result, real);
end;

function Image_alloc_v(var AControl): Tvalue;
begin
  result := Image_alloc(ap_cImage, TImage(AControl))
end;

function Image_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TImage;
begin
  real := TImage.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Image_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function Image_get_canvas(This: Tvalue): Tvalue; cdecl;
var
  real: TImage;
begin
  real := ap_data_get_struct(This);
  if real.Canvas = nil then
    result := Qnil
  else
  begin
    result := Canvas_alloc(ap_cCanvas, real.Canvas);
    rb_iv_set(result, '@owner', This);
  end;
end;

function ap_cImageList: Tvalue; stdcall;
begin
  result := cImageList;
end;

function ImageList_new(This: Tvalue): Tvalue; cdecl;
var
  real: TImageList;
begin
  real := TImageList.Create(nil);
  result := CompoAlloc(This, real);

  rb_obj_call_init(result, 0, nil);
end;

function ImageList_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TCustomImageList;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Count);
end;

function ImageList_add(This, vBmap, vMask: Tvalue): Tvalue; cdecl;
var
  real: TCustomImageList;
  Bmap, Mask: TBitmap;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(vBmap, TBitmap, Bmap);
  case RTYPE(vMask) of
  T_DATA:
    begin
      ap_data_get_object(vMask, TBitmap, Mask);
      result := INT2FIX(real.Add(Bmap, Mask));
    end;
  T_FIXNUM:
    begin
      result := INT2FIX(real.AddMasked(Bmap, FIX2INT(Mask)));
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
    result := Qnil; // avoid warning
  end;
end;

function ImageList_add_icon(This, vIcon: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function ImageList_add_images(This, v: Tvalue): Tvalue; cdecl;
var
  real, other: TCustomImageList;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TCustomImageList, other);
  real.AddImages(other);
  result := Qnil;
end;

procedure Init_Image;
begin
  cImage := DefineCompoClass(mPhi, TImage, cControl, Image_alloc_v);
  DefineSingletonMethod(cImage, 'new', Image_new);
  DefineAttrGet(cImage, 'canvas', Image_get_canvas);

  cImageList := DefineCompoClass(mPhi, TImageList, ap_cObject, nil);
  rb_define_singleton_method(cImageList, 'new', @ImageList_new, 0);
  DefineAttrGet(cImageList, 'count', ImageList_get_count);
  rb_define_method(cImageList, 'add', @ImageList_add, 2);
  rb_define_method(cImageList, 'add_icon', @ImageList_add_icon, 1);
  rb_define_method(cImageList, 'add_images', @ImageList_add_images, 1);
end;

exports
  ap_cImage,
  Image_alloc,
  ap_cImageList;

end.
