unit uIO;

interface

uses Rubies;

var
  Stdout: TGetStrProc;
  gets: TRetStrFunc;
  getc: TRetChrFunc;

function Phi_write(This, str: Tvalue): Tvalue; cdecl;
function Phi_gets(This: Tvalue): Tvalue; cdecl;
function Phi_getc(This: Tvalue): Tvalue; cdecl;
function Phi_flush(This: Tvalue): Tvalue; cdecl;
function Phi_close(This: Tvalue): Tvalue; cdecl;
function Phi_undef_stdio(This: Tvalue): Tvalue; cdecl;
procedure io_stdout(S: string);
function io_gets: string;
function io_getc: Char;

implementation

uses Types, SysUtils, Classes;

function Phi_write(This, str: Tvalue): Tvalue; cdecl;
var
  len: Integer;
begin
  len := 0;
  if @Stdout <> nil then
  begin
    if RTYPE(str) <> T_STRING then str := rb_obj_as_string(str); { to_s }
    len := ap_str_len(str);
    if len <> 0 then Stdout(STR2CSTR(str));
  end;
  result := INT2FIX(len);
end;

function Phi_gets(This: Tvalue): Tvalue; cdecl;
var
  S: string;
begin
  result := Qnil;
  if @gets <> nil then
  begin
    S := gets;
    if Length(S) <> 0 then result := rb_str_new2(PChar(S));
  end;
  rb_lastline_set(result); // $_ set
end;

function Phi_getc(This: Tvalue): Tvalue; cdecl;
var
  c: Char;
begin
  result := Qnil;
  if @getc <> nil then
  begin
    c := getc;
    if c <> #0 then result := CHR2FIX(c);
  end;
end;

function Phi_flush(This: Tvalue): Tvalue; cdecl;
begin
//  FlushFileBuffers(GetStdHandle(STD_OUTPUT_HANDLE));
  result := This;
end;

function Phi_close(This: Tvalue): Tvalue; cdecl;
begin
//  FlushFileBuffers(GetStdHandle(STD_OUTPUT_HANDLE));
  result := Qnil;
end;

function Phi_undef_stdio(This: Tvalue): Tvalue; cdecl;
begin
  ap_set_stdin(Qnil);
  ap_set_stdout(Qnil);
  ap_set_stderr(Qnil);
  ap_set_defout(Qnil);
  result := Qnil;
end;

procedure io_stdout(S: string);
begin
  Write(S);
end;

function io_gets: string;
var
  S: string;
begin
  try
    ReadLn(S);
    if Length(S) <> 0 then // 0 if \C-z. Eof cannot use This case.
      if S[1] = #4{\C-d} then SetLength(S, 0)
      else S := S + #10;
    result := S;
  except
    on E: Exception do;
  end;
end;

function io_getc: Char;
var
  c: Char;
begin
  try
    Read(c);
    result := c;
  except
    on E: Exception do result := #0;
  end;
end;

end.
