unit uHeapStatus;

interface

uses Rubies;

{
  THeapStatus = record
    TotalAddrSpace: Cardinal;
    TotalUncommitted: Cardinal;
    TotalCommitted: Cardinal;
    TotalAllocated: Cardinal;
    TotalFree: Cardinal;
    FreeSmall: Cardinal;
    FreeBig: Cardinal;
    Unused: Cardinal;
    Overhead: Cardinal;
    HeapErrorCode: Cardinal;
  end;
}
var
  sHeapStatus: Tvalue;

procedure Init_HeapStatus;

implementation

uses uStrUtils, uPhi;

function HeapStatus_alloc(real: THeapStatus): Tvalue;
var
  args: array of Tvalue;
begin
  SetLength(args, 10);
  args[0] := INT2FIX(real.TotalAddrSpace);
  args[1] := INT2FIX(real.TotalUncommitted);
  args[2] := INT2FIX(real.TotalCommitted);
  args[3] := INT2FIX(real.TotalAllocated);
  args[4] := INT2FIX(real.TotalFree);
  args[5] := INT2FIX(real.FreeSmall);
  args[6] := INT2FIX(real.FreeBig);
  args[7] := INT2FIX(real.Unused);
  args[8] := INT2FIX(real.Overhead);
  args[9] := INT2FIX(real.HeapErrorCode);
  result := ap_struct_new(sHeapStatus, args);
end;

function Phi_heap_status(This: Tvalue): Tvalue; cdecl;
begin
  result := HeapStatus_alloc(GetHeapStatus);
end;

procedure Init_HeapStatus;
var
  args: array of PChar;
begin
  SetLength(args, 11);
  args[0] := PChar(LowerCase1('TotalAddrSpace'));
  args[1] := PChar(LowerCase1('TotalUncommitted'));
  args[2] := PChar(LowerCase1('TotalCommitted'));
  args[3] := PChar(LowerCase1('TotalAllocated'));
  args[4] := PChar(LowerCase1('TotalFree'));
  args[5] := PChar(LowerCase1('FreeSmall'));
  args[6] := PChar(LowerCase1('FreeBig'));
  args[7] := PChar(LowerCase1('Unused'));
  args[8] := PChar(LowerCase1('Overhead'));
  args[9] := PChar(LowerCase1('HeapErrorCode'));
  args[10] := nil;
  sHeapStatus := ap_struct_define('HeapStatus', args);
  rb_global_variable(@sHeapStatus);

  DefineModuleAttrGet(mPhi, 'heap_status', Phi_heap_status);
end;

end.
