unit uGroupBox;

interface

uses Rubies, QStdCtrls;

var
  cGroupBox: Tvalue;

function ap_cGroupBox: Tvalue; stdcall;
procedure GroupBox_setup(obj: Tvalue; real: TGroupBox);
function GroupBox_alloc(This: Tvalue; real: TGroupBox): Tvalue; stdcall;
procedure Init_GroupBox;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cGroupBox: Tvalue; stdcall;
begin
  result := cGroupBox;
end;

procedure GroupBox_setup(obj: Tvalue; real: TGroupBox);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  ap_set_child_attr_module(obj);
  AssignPropMethod(real, [Handle]);
end;

function GroupBox_alloc(This: Tvalue; real: TGroupBox): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  GroupBox_setup(result, real);
end;

function GroupBox_alloc_v(var AControl): Tvalue;
begin
  result := GroupBox_alloc(ap_cGroupBox, TGroupBox(AControl))
end;

function GroupBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TGroupBox;
begin
  real := TGroupBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  GroupBox_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_GroupBox;
begin
  cGroupBox := DefineCompoClass(mPhi, TGroupBox, cWinControl, GroupBox_alloc_v);
  DefineSingletonMethod(cGroupBox, 'new', GroupBox_new);
end;

exports
  ap_cGroupBox,
  GroupBox_alloc;

end.
