unit uGrid;

interface

uses Rubies, QGrids;

type
  TGridDrawStateKind = (gdSelected, gdFocused, gdFixed);

var
  cCustomGrid, cDrawGrid, cStringGrid: Tvalue;

function ap_cCustomGrid: Tvalue; stdcall;
function ap_cDrawGrid: Tvalue; stdcall;
function ap_cStringGrid: Tvalue; stdcall;
procedure DrawGrid_setup(obj: Tvalue; real: TDrawGrid);
function DrawGrid_alloc(This: Tvalue; real: TDrawGrid): Tvalue;
procedure StringGrid_setup(obj: Tvalue; real: TStringGrid);
function StringGrid_alloc(This: Tvalue; real: TStringGrid): Tvalue;
procedure Init_Grid;

implementation

uses
  Types, Classes, uStrUtils,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uRect, uBrush, uCanvas, uFont,
  uComponent, uControl;

function ap_cCustomGrid: Tvalue; stdcall;
begin
  result := cCustomGrid;
end;

function CustomGrid_cell_rect(This, col, row: Tvalue): Tvalue; cdecl;
var
  real: TCustomGrid;
  rect: TRect;
begin
  real := ap_data_get_struct(This);
  rect := TDrawGrid(real).CellRect(NUM2INT(col), NUM2INT(row));
  result := Rect_alloc(cRect, rect);
end;

function ap_cDrawGrid: Tvalue; stdcall;
begin
  result := cDrawGrid;
end;

function ap_cStringGrid: Tvalue; stdcall;
begin
  result := cStringGrid;
end;

procedure DrawGrid_setup(obj: Tvalue; real: TDrawGrid);
begin
  rb_iv_set(obj, '@brush', Brush_alloc(cBrush, real.Brush));
  rb_iv_set(obj, '@canvas', Canvas_alloc(cCanvas, real.Canvas));
  rb_iv_set(obj, '@font', Font_alloc(cFont, real.Font));
  AssignPropMethod(real, [Handle]);
end;

function DrawGrid_alloc(This: Tvalue; real: TDrawGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  DrawGrid_setup(result, real);
end;

function DrawGrid_alloc_v(var AControl): Tvalue;
begin
  result := DrawGrid_alloc(cDrawGrid, TDrawGrid(AControl))
end;

function DrawGrid_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := TDrawGrid.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DrawGrid_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function DrawGrid_mouse_to_cell(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  col, row: Longint;
begin
  real := ap_data_get_struct(This);
  real.MouseToCell(NUM2INT(x), NUM2INT(y), col, row);
  result := rb_ary_new;
  rb_ary_push(result, INT2FIX(col));
  rb_ary_push(result, INT2FIX(row));
end;

procedure StringGrid_setup(obj: Tvalue; real: TStringGrid);
begin
  rb_iv_set(obj, '@brush', Brush_alloc(cBrush, real.Brush));
  rb_iv_set(obj, '@canvas', Canvas_alloc(cCanvas, real.Canvas));
  rb_iv_set(obj, '@font', Font_alloc(cFont, real.Font));
  AssignPropMethod(real, [Handle]);
end;

function StringGrid_alloc(This: Tvalue; real: TStringGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  StringGrid_setup(result, real);
end;

function StringGrid_alloc_v(var AControl): Tvalue;
begin
  result := StringGrid_alloc(cStringGrid, TStringGrid(AControl))
end;

function StringGrid_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
begin
  real := TStringGrid.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  StringGrid_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function StringGrid_get_cells(This, col, row: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(WideCharToString(PWideChar(real.Cells[FIX2INT(col), FIX2INT(row)]))));
end;

function StringGrid_set_cells(This, col, row, v: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
begin
  real := ap_data_get_struct(This);
  real.Cells[FIX2INT(col), FIX2INT(row)] := STR2CSTR(v);
  result := v;
end;

procedure Init_Grid;
begin
  DefineConstSetType(mPhi, TypeInfo(TGridDrawStateKind));
  cCustomGrid := DefineCompoClass(mPhi, TCustomGrid, cWinControl, nil);
  rb_define_method(cCustomGrid, 'cell_rect', @CustomGrid_cell_rect, 2);
  rb_define_attr(cCustomGrid, 'canvas', 1, 0);

  cDrawGrid := DefineCompoClass(mPhi, TDrawGrid, cCustomGrid, DrawGrid_alloc_v);
  DefineSingletonMethod(cDrawGrid, 'new', DrawGrid_new);
  rb_define_method(cDrawGrid, 'mouse_to_cell', @DrawGrid_mouse_to_cell, 2);
  DefineAttrMethod_retval(cDrawGrid, 'on_select_cell');

  cStringGrid := DefineCompoClass(mPhi, TStringGrid, cDrawGrid, StringGrid_alloc_v);
  DefineSingletonMethod(cStringGrid, 'new', StringGrid_new);
  rb_define_method(cStringGrid, 'get_cells', @StringGrid_get_cells, 2);
  rb_define_method(cStringGrid, 'set_cells', @StringGrid_set_cells, 3);
end;

exports
  ap_cCustomGrid,
  ap_cDrawGrid,
  ap_cStringGrid;

end.
