unit uFrame;

interface

uses Rubies, QForms;

var
  cFrame: Tvalue;

procedure Frame_setup(obj: Tvalue; real: TFrame);
function Frame_alloc(This: Tvalue; real: TFrame): Tvalue;
procedure Init_Frame;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

procedure Frame_setup(obj: Tvalue; real: TFrame);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  ap_set_child_attr_module(obj);
  AssignPropMethod(real, [Handle]);
end;

function Frame_alloc(This: Tvalue; real: TFrame): Tvalue;
begin
  result := ChildAlloc(This, real);
  Frame_setup(result, real);
end;

function Frame_alloc_v(var AControl): Tvalue;
begin
  result := Frame_alloc(cFrame, TFrame(AControl));
end;

function Frame_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TFrame;
begin
  real := TFrame.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Frame_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_Frame;
begin
  cFrame := DefineCompoClass(mPhi, TFrame, cWinControl, Frame_alloc_v);
  DefineSingletonMethod(cFrame, 'new', Frame_new);
end;


end.
