unit uForm;

interface

uses QForms, Rubies;

var
  cForm: Tvalue;

function ap_cForm: Tvalue; stdcall;
procedure Form_setup(obj: Tvalue; real: TForm);
function Form_alloc(This: Tvalue; real: TForm): Tvalue; stdcall;
procedure FormSetParent(real: TForm; name: PChar);
procedure Init_form;

implementation

uses
  Classes, QControls, PhiForm,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont, uCanvas, uScreen, uBitmap,
  uComponent, uMenu, uControl;

function ap_cForm: Tvalue; stdcall;
begin
  result := cForm;
end;

procedure Form_setup(obj: Tvalue; real: TForm);
var
  ceo: Tvalue;
begin
  rb_iv_set(obj, '@canvas', Canvas_alloc(cCanvas, real.Canvas));
  rb_iv_set(obj, '@font', Font_alloc(cFont, real.Font));
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  ap_set_child_attr_module(obj);
  ceo := vScreen;
  rb_iv_set(obj, '@parent', ceo);
  AssignPropMethod(real, [Handle]);
end;

function Form_alloc(This: Tvalue; real: TForm): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Form_setup(result, real);
end;

function Form_alloc_v(var AControl): Tvalue;
var
  real: TForm;
begin
  real := TForm(AControl);
  result := FormAlloc(cForm, real);
  Form_setup(result, real);
end;

procedure FormSetParent(real: TForm; name: PChar);
var
  obj, ceo, module: Tvalue;
begin
  obj := real.tag;
  ceo := vScreen; // rb_iv_get(obj, '@parent');
  rb_iv_set(ceo, PChar('@'+name), obj);
  module := rb_iv_get(ceo, '@child_attr_module');
  rb_define_attr(module, name, 1, 0);
  real.name := name;
end;

function Form_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
  args: array of Tvalue;
begin
  SetLength(args, argc);
  args := argv;

  real := TPhiForm.Create(nil);
  real.width  := 320;
  real.height := 200;
  real.left := (Screen.width  - real.width ) div 2;
  real.top  := (Screen.height - real.height) div 2;

  result := FormAlloc(This, real);
  Form_setup(result, real);

  if argc > 0 then
    FormSetParent(real, StringOrSymbolToStr(args[0]));

  if argc > 1 then
    rb_funcall2(result, rb_intern('caption='), 1, @args[1]);

  rb_obj_call_init(result, argc, argv);
end;

function Form_close(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  real.Close;
  result := Qnil;
end;

function Form_show(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  real.Show;
  result := This;
end;

function Form_show_modal(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ShowModal);
end;

function Form_get_bitmap(This: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function Form_get_active_control(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(This);
  result := real.ActiveControl.tag;
end;

function Form_set_active_control(This, v: Tvalue): Tvalue; cdecl;
var
  real: TForm;
  Control: TWinControl;
begin
  real := ap_data_get_struct(This);
  Control := ap_data_get_struct(v);
  real.ActiveControl := Control;
  result := v;
end;

function Form_get_modal_result(this: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(this);
  result := INT2FIX(real.ModalResult);
end;

function Form_set_modal_result(this, v: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(this);
  real.ModalResult := FIX2INT(v);
  result := v;
end;

function Form_get_canvas(This: Tvalue): Tvalue; cdecl;
begin
  result := rb_iv_get(This, '@canvas');
end;

function Form_get_active(This: Tvalue): Tvalue; cdecl;
var
  real: TForm;
begin
  real := ap_data_get_struct(this);
  result := ap_bool(real.Active);
end;

procedure Init_form;
begin
  RegisterClass(TPhiForm);
  PhiAllocFuncList.AddObject('TPhiForm', @Form_alloc_v);

  DefineConstSetType(mPhi, TypeInfo(TWindowState));
  DefineConstSetType(mPhi, TypeInfo(TPosition));

  cForm := DefineCompoClass(mPhi, TForm, cWinControl, Form_alloc_v);

  DefineSingletonMethod(cForm, 'new', Form_new);
  rb_define_method(cForm, 'close', @Form_close, 0);
  rb_define_method(cForm, 'show', @Form_show, 0);
  rb_define_method(cForm, 'show_modal', @Form_show_modal, 0);
  // vcl: GetFormImage
  rb_define_method(cForm, 'get_bitmap', @Form_get_bitmap, 0);

  DefineAttrGet(cForm, 'focus_control', Form_get_active_control);
  DefineAttrSet(cForm, 'focus_control', Form_set_active_control);
  DefineAttrGet(cForm, 'canvas', Form_get_canvas);
  DefineAttrGet(cForm, 'modal_result', Form_get_modal_result);
  DefineAttrSet(cForm, 'modal_result', Form_set_modal_result);
  DefineAttrGet(cForm, 'active', Form_get_active);

  DefineAttrMethod_retval(cForm, 'on_close');
  DefineAttrMethod_retval(cForm, 'on_close_query');
  DefineAttrMethod(cForm, 'on_drop_files');
end;

exports
  ap_cForm,
  Form_alloc;

end.
