unit uFont;

interface

uses TypInfo, QGraphics, Rubies, uIntern, uAlloc, uProp;

var
  cFont: Tvalue;

function ap_cFont: Tvalue; stdcall;
function Font_alloc(This: Tvalue; real: TFont): Tvalue; stdcall;
procedure Init_Font;

implementation

uses uPhi;

function ap_cFont: Tvalue; stdcall;
begin
  result := cFont;
end;

function Font_alloc(This: Tvalue; real: TFont): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
end;

function Font_new(This: Tvalue): Tvalue; cdecl;
var
  real: TFont;
begin
  real := TFont.Create;
  result := ObjAlloc(This, real);

  rb_obj_call_init(result, 0, nil);
end;

function Font_to_s(This: Tvalue): Tvalue; cdecl;
var
  real: TFont;
  klass: Tvalue;
begin
  real := ap_data_get_struct(This);

  result := rb_str_new2('#');
  rb_str_cat(result, '<', 1);

  klass := CLASS_OF(This);
  klass := rb_class_path(klass);
  rb_str_concat(result, klass);
  rb_str_cat(result, ':', 1);

  ap_str_cat(result, ' name=');
  rb_str_concat(result, ap_get_str_prop(real, 'Name', '"'));
  ap_str_cat(result, ' charset=');
  ap_str_cat(result, GetEnumProp1(real, 'Charset'));
  ap_str_cat(result, ' height=');
  ap_str_cat_int(result, GetOrdProp(real, 'Height'));
  ap_str_cat(result, ' color=');
  ap_str_cat(result, GetEnumProp1(real, 'Color'));
  ap_str_cat(result, ' style=');
  ap_str_cat(result, GetSetProp1(real, 'Style', True));
  ap_str_cat(result, ' pitch=');
  ap_str_cat(result, GetEnumProp1(real, 'Pitch'));

  rb_str_cat(result, '>', 1);
end;

procedure Init_Font;
begin
  DefineConstSetType(mPhi, TypeInfo(TFontPitch));
  DefineConstSetType(mPhi, TypeInfo(TFontStyle));

  cFont := rb_define_class_under(mPhi, 'Font', ap_cObject);
  DefineProp(cFont, TFont);

  rb_define_singleton_method(cFont, 'new', @Font_new, 0);
  rb_define_method(cFont, 'to_s', @Font_to_s, 0);
end;

exports
  ap_cFont,
  Font_alloc;

end.
