unit uEdit;

interface

uses Rubies, QStdCtrls;

var
  cEdit: Tvalue;

function ap_cEdit: Tvalue; stdcall;
procedure Edit_setup(obj: Tvalue; real: TEdit);
function Edit_alloc(This: Tvalue; real: TEdit): Tvalue; stdcall;
procedure Init_edit;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uFont,
  uComponent, uControl;

function ap_cEdit: Tvalue; stdcall;
begin
  result := cEdit;
end;

procedure Edit_setup(obj: Tvalue; real: TEdit);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [Handle]);
end;

function Edit_alloc(This: Tvalue; real: TEdit): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Edit_setup(result, real);
end;

function Edit_alloc_v(var AControl): Tvalue;
begin
  result := Edit_alloc(cEdit, TEdit(AControl));
end;

function Edit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TEdit;
begin
  real := TEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Edit_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_edit;
begin
  DefineConstSetType(mPhi, TypeInfo(TEditCharCase));
  cEdit := DefineCompoClass(mPhi, TEdit, cWinControl, Edit_alloc_v);
  DefineSingletonMethod(cEdit, 'new', Edit_new);
end;

exports
  ap_cEdit,
  Edit_alloc;

end.
