unit uConv;

interface

uses Types, Classes, QStdCtrls, QComCtrls, Variants, Rubies;

function dl_Boolean(v: Tvalue): Boolean; stdcall;
function ap_Fixnum(v: Integer): Tvalue; stdcall;
function dl_Integer(v: Tvalue): Integer; stdcall;
function ap_Float(v: Double): Tvalue; stdcall;
function dl_Double(v: Tvalue): Double; stdcall;
function ap_String(S: string): Tvalue; stdcall;
function dl_String(v: Tvalue): string; stdcall;
function ap_Variant(A: Variant): Tvalue; stdcall;
function dl_Variant(v: Tvalue): Variant; stdcall;
function ap_set_to_ary(var v): Tvalue; stdcall;
function dl_ary_to_set(ary: Tvalue): Integer; stdcall;
function dl_ClassName(This: Tvalue): string;

implementation

uses uDateTime;

function dl_Boolean(v: Tvalue): Boolean;
begin
  result := RTEST(v);
end;

function ap_Fixnum(v: Integer): Tvalue;
begin
  result := INT2FIX(v);
end;

function dl_Integer(v: Tvalue): Integer;
begin
  result := NUM2INT(v);
end;

function ap_Float(v: Double): Tvalue;
begin
  result := rb_float_new(v);
end;

function dl_Double(v: Tvalue): Double;
begin
  result := rb_num2dbl(v);
end;

function ap_String(S: string): Tvalue;
begin
  result := rb_str_new(PChar(S), length(S));
end;

function dl_String(v: Tvalue): string;
begin
  Check_Type(v, T_STRING);
  SetString(result, ap_str_ptr(v), ap_str_len(v));
end;

function ap_Variant(A: Variant): Tvalue;
begin
  result := Qnil;
  case VarType(A) of
  varSmallint, varInteger, varByte:  result := ap_Fixnum(A);
  varSingle, varDouble, varCurrency: result := ap_Float(A);
  varOleStr, varStrArg, varString:   result := ap_String(string(A));
  varBoolean:                        result := ap_bool(A);
  varDate:                           result := ap_DateTime(A);
  varEmpty, varNull:                 result := Qnil;
  //
  // not yet
  //
  varDispatch: result := rb_str_new2('varDispatch');
  varError:    result := rb_str_new2('varError');
  varVariant:  result := rb_str_new2('varVariant');
  varUnknown:  result := rb_str_new2('varUnknown');
  varAny:      result := rb_str_new2('varAny');
  varTypeMask: result := rb_str_new2('varTypeMask');
  varArray:    result := rb_str_new2('varArray');
  end;
end;

function dl_Variant(v: Tvalue): Variant;
begin
  case RTYPE(v) of
  T_STRING: result := Variant(dl_String(v));
  T_FIXNUM: result := Variant(NUM2INT(v));
  T_BIGNUM: result := Variant(NUM2INT(v)); //??
  T_FLOAT : result := Variant(NUM2DBL(v));
  T_TRUE  : result := Variant(True);
  T_FALSE : result := Variant(False);
  T_DATA  :
    if ap_kind_of(v, ap_cDateTime) then begin
      result := Variant(dl_DateTime(v));
    end else begin
      ap_raise(ap_eArgError, sWrong_arg_type);
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
end;

function ap_set_to_ary(var v): Tvalue;
var
  i: Shortint;
  n: Integer;
  ary: Tvalue;
begin
  Move(v, i, Sizeof(i));
  ary := rb_ary_new;
  n := 0;
  while i > 0 do
  begin
    if i and 1 = 1 then rb_ary_push(ary, INT2FIX(n));
    i := i shr 1;
    Inc(n);
  end;
  result := ary;
end;

function dl_ary_to_set(ary: Tvalue): Integer;
var
  len: Integer;
  ptr: Pvalue;
  v: Integer;
  i: Integer;
begin
  Check_Type(ary, T_ARRAY);
  len := ap_ary_len(ary);
  ptr := ap_ary_ptr(ary);
  v := 0;
  for i := 0 to len-1 do
  begin
    v := v + (1 shl NUM2INT(ptr^));
    Inc(ptr);
  end;
  result := v;
end;

function dl_ClassName(This: Tvalue): string;
begin
  result := dl_String(rb_class_path(CLASS_OF(This)));
end;

exports
  dl_Boolean,
  ap_Fixnum,
  dl_Integer,
  ap_Float,
  dl_Double,
  ap_String,
  dl_String,
  ap_Variant,
  dl_Variant,
  ap_set_to_ary,
  dl_ary_to_set,
  dl_ClassName;

end.
