unit uControl;

interface

uses QControls, Rubies;

var
  cControl, cWinControl: Tvalue;

procedure ClearEvents(AControl: TControl); stdcall;
function ap_cControl: Tvalue; stdcall;
function ap_cWinControl: Tvalue; stdcall;
procedure Init_control;

implementation

uses
  Types, TypInfo,
  uIntern, uProp, uPhi, uConv, uPoint, uRect, uComponent;

procedure ClearEvents(AControl: TControl); stdcall;
var
  i: Integer;
  real: TWinControl;
  obj, events: Tvalue;
begin
  if not (AControl is TWinControl) then Exit;
  real := TWinControl(AControl);
  for i := 0 to real.ControlCount-1 do
    ClearEvents(real.Controls[i]);
  obj := real.tag;
  if obj = 0 then Exit; // undefined
  events := rb_iv_get(obj, '@events');
  if events <> Qnil then
    rb_funcall2(events, id_clear, 0, nil);
end;

function ap_cControl: Tvalue; stdcall;
begin
  result := cControl;
end;

function ap_cWinControl: Tvalue; stdcall;
begin
  result := cWinControl;
end;

function Control_show(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
asm
  FInit;
end;
  real.Show;
  result := Qnil;
end;

function Control_hide(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.Hide;
  result := Qnil;
end;

function Control_bring_to_front(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.BringToFront;
  result := Qnil;
end;

function Control_send_to_back(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.SendToBack;
  result := Qnil;
end;

function Control_screen_to_client(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  point: TPoint;
begin
  real := ap_data_get_struct(This);
  point := real.ScreenToClient(TPoint(ap_data_get_struct(v)^));
  result := Point_alloc(cPoint, point);
end;

function Control_set_bounds(This, left, top, width, height: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.SetBounds(FIX2INT(left), FIX2INT(top), FIX2INT(width), FIX2INT(height));
  result := This;
end;

function Control_client_to_screen(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  point: TPoint;
begin
  real := ap_data_get_struct(This);
  point := real.ClientToScreen(TPoint(ap_data_get_struct(v)^));
  result := Point_alloc(cPoint, point);
end;

function Control_set_rect(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.BoundsRect := PRect(ap_data_get_struct(v))^;
  result := v;
end;

function Control_get_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := Rect_alloc(cRect, real.BoundsRect);
end;

function Control_set_align(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.Align := TAlign(FIX2INT(v));
  result := v;
end;

function Control_get_align(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.Align));
end;

function Control_set_parent(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  control: TWinControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TWinControl, control);
  real.parent := TWinControl(control);
  rb_iv_set(This, '@parent', v);
  result := v;
end;

function Control_begin_drag(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  args: array of Tvalue;
  Immediate: Boolean;
  Threshold: Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  if argc > 1 then
    Threshold := FIX2INT(args[1])
  else
    Threshold := -1
  ;
  args := argv;
  real := ap_data_get_struct(This);
  Immediate := RTEST(args[0]);
  real.BeginDrag(Immediate, Threshold);
  result := Qnil;
end;

function Control_focused_p(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.focused);
end;

function Control_set_focus(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.SetFocus;
  result := Qnil;
end;

function Control_scale_by(This, m, d: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.ScaleBy(FIX2INT(m), FIX2INT(d));
  result := Qnil;
end;

function Control_invalidate(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.invalidate;
  result := Qnil;
end;

function Control_update(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.update;
  result := Qnil;
end;

function Control_repaint(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.repaint;
  result := Qnil;
end;

function Control_refresh(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.refresh;
  result := Qnil;
end;

function Control_get_handle(This: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function Control_set_control_state(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  SetOrdProp(real, 'ControlState', dl_ary_to_set(v));
  result := v;
end;

function Control_get_control_state(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  state: TControlState;
begin
  real := ap_data_get_struct(This);
  state := real.ControlState;
  result := ap_set_to_ary(state);
end;

function Control_set_control_style(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  SetOrdProp(real, 'ControlStyle', dl_ary_to_set(v));
  result := v;
end;

function Control_get_control_style(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  style: TControlStyle;
begin
  real := ap_data_get_struct(This);
  style := real.ControlStyle;
  result := ap_set_to_ary(style);
end;

function Control_get_controls(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
  i: Integer;
  args: array of Tvalue;
  obj, control_class, kind_p, push_p: Tvalue;
begin
  SetLength(args, argc);
  args := argv;

  if argc > 0 then
    control_class := args[0]
  else
    control_class := Qnil;

  if argc > 1 then
    kind_p := args[1]
  else
    kind_p := Qnil;

  real := ap_data_get_struct(This);

  if rb_block_given_p <> 0 then
    result := Qnil
  else
    result := rb_ary_new;

  for i := 0 to real.ControlCount-1 do
  begin
    obj := real.Controls[i].tag;
    if obj = 0 then Continue;
    if control_class = Qnil then
      push_p := Qtrue
    else
      if RTEST(kind_p) then
        push_p := rb_obj_is_kind_of(obj, control_class)
      else
        push_p := rb_obj_is_instance_of(obj, control_class);

    if RTEST(push_p) then
      if rb_block_given_p <> 0 then
        rb_yield(obj)
      else
        rb_ary_push(result, obj);

  end;
end;

function Control_get_control_count(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ControlCount);
end;

function Control_stop_align(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  try
    real.DisableAlign;
    result := rb_yield(Qnil);
  finally
    real.EnableAlign;
  end;
end;

function Control_handle_needed(This: TValue): TValue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.HandleNeeded;
  Result := Qnil;
end;

function Control_control_at(This, v: TValue): TValue; cdecl;
var
  real: TWinControl;
  AControl: TControl;
begin
  real := ap_data_get_struct(This);
  AControl := real.ControlAtPos(TPoint(ap_data_get_struct(v)^), True, True);
  if AControl = nil then
    Result := Qnil
  else
    Result := AControl.tag;
end;

procedure Init_control;
begin
  cControl := DefineCompoClass(mPhi, TControl, cComponent, nil);
  { methods }
  rb_define_method(cControl, 'show', @Control_show, 0);
  rb_define_method(cControl, 'hide', @Control_hide, 0);
  rb_define_method(cControl, 'bring_to_front', @Control_bring_to_front, 0);
  rb_define_method(cControl, 'send_to_back', @Control_send_to_back, 0);
  rb_define_method(cControl, 'screen_to_client', @Control_screen_to_client, 1);
  rb_define_method(cControl, 'client_to_screen', @Control_client_to_screen, 1);
  rb_define_method(cControl, 'set_bounds', @Control_set_bounds, 4);
  DefineMethod(cControl, 'begin_drag', Control_begin_drag);
  { event handlers (return argument#1) }

  DefineAttrMethod_retval(cControl, 'on_can_resize');
  DefineAttrMethod_retval(cControl, 'on_constrained_resize');

  { properties }
  DefineAttrSet(cControl, 'rect', Control_set_rect);
  DefineAttrGet(cControl, 'rect', Control_get_rect);
  DefineAttrSet(cControl, 'align', Control_set_align);
  DefineAttrGet(cControl, 'align', Control_get_align);
  DefineAttrSet(cControl, 'parent', Control_set_parent);
  DefineAttrGet(cControl, 'handle', Control_get_handle);
  DefineAttrSet(cControl, 'control_state', Control_set_control_state);
  DefineAttrGet(cControl, 'control_state', Control_get_control_state);
  DefineAttrSet(cControl, 'control_style', Control_set_control_style);
  DefineAttrGet(cControl, 'control_style', Control_get_control_style);
  { attributes }
  rb_define_attr(cControl, 'parent', 1, 0);

  cWinControl := DefineCompoClass(mPhi, TWinControl, cControl, nil);
  rb_define_method(cWinControl, 'focused?', @Control_focused_p, 0);
  rb_define_method(cWinControl, 'set_focus', @Control_set_focus, 0);
  rb_define_method(cWinControl, 'scale_by', @Control_scale_by, 2);
  rb_define_method(cWinControl, 'invalidate', @Control_invalidate, 0);
  rb_define_method(cWinControl, 'update', @Control_update, 0);
  rb_define_method(cWinControl, 'repaint', @Control_repaint, 0);
  rb_define_method(cWinControl, 'refresh', @Control_refresh, 0);
  DefineMethod(cWinControl, 'controls', Control_get_controls);
  DefineAttrGet(cWinControl, 'control_count', Control_get_control_count);

  DefineAttrMethod_retval(cWinControl, 'on_key_down');
  DefineAttrMethod_retval(cWinControl, 'on_key_press');
  DefineAttrMethod_retval(cWinControl, 'on_key_up');
  DefineAttrMethod_retval(cWinControl, 'on_dock_over');
  DefineAttrMethod_retval(cWinControl, 'on_un_dock');
  DefineAttrMethod_retval(cWinControl, 'on_get_site_info');

  rb_define_method(cWinControl, 'stop_align', @Control_stop_align, 0);
  rb_define_method(cWinControl, 'handle_needed', @Control_handle_needed, 0);
  rb_define_method(cWinControl, 'control_at', @Control_control_at, 1);
end;

exports
  ClearEvents,
  ap_cControl,
  ap_cWinControl;

end.
