unit uComponent;

interface

uses Rubies, Classes;

var
  cComponent: Tvalue;

procedure RemoveParentAttr(real: TComponent); stdcall;
function ap_cComponent: Tvalue; stdcall;
procedure SetParentAttr(obj, ceo: Tvalue; name: PChar);
procedure CompoSetup(argc: integer; argv: Pointer; real: TComponent); stdcall;
function DefineCompoClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TFuncAlloc_v): Tvalue; stdcall;
procedure Init_Component;

implementation

uses
  QControls,
  uHandle, uError, uPhi, uProp, uPropInfo, uTypeInfo, uMarshal;

procedure RemoveParentAttr(real: TComponent); stdcall;
var
  obj, ceo, module: Tvalue;
begin
  if Length(real.name) = 0 then Exit;
  obj := real.tag;
  ceo := rb_iv_get(obj, '@parent');
  rb_iv_set(ceo, PChar('@'+real.name), Qnil);

  module := rb_iv_get(ceo, '@child_attr_module');
  if module = Qnil then Exit;
  rb_undef_method(module, PChar(real.name));
end;

function ap_cComponent: Tvalue; stdcall;
begin
  result := cComponent;
end;

procedure value_set_if_defined(obj: Tvalue; S: PChar; v:Tvalue);
begin
  if Boolean(rb_method_boundp(CLASS_OF(obj), rb_intern(S), 1)) then
    rb_funcall2(obj, rb_intern(S), 1, @v);
end;

procedure SetParentAttr(obj, ceo: Tvalue; name: PChar);
var
  module: Tvalue;
begin
  rb_iv_set(ceo, PChar('@'+name), obj);
  module := rb_iv_get(ceo, '@child_attr_module');
  if module = Qnil then
    ap_raise(eDelphiError, 'child attr module not defined');
  rb_define_attr(module, name, 1, 0);
end;

procedure CompoSetup(argc: integer; argv: Pointer; real: TComponent); stdcall;
var
  args: array of Tvalue;
  parent: TComponent;
  obj, ceo: Tvalue;
  str: PChar;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  ap_data_get_object(args[0], TComponent, parent);

  obj := real.tag;
  if parent = nil then
    ceo := Qnil
  else
    ceo := parent.tag;

  if argc > 1 then
  begin
    str := StringOrSymbolToStr(args[1]);
    SetParentAttr(obj, ceo, str);
    real.name := str;
  end;

  if argc > 2 then
  begin
    value_set_if_defined(obj, 'text=', args[2]);
    value_set_if_defined(obj, 'caption=', args[2]);
  end;

  if (real is TControl) and (parent is TWinControl) then
    TControl(real).parent := TWinControl(parent);
  rb_iv_set(obj, '@parent', ceo);
end;

function DefineCompoClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TFuncAlloc_v): Tvalue; stdcall;
var
  S: string;
begin
  RegisterClass(AClass);
  S := AClass.ClassName;
  PhiAllocFuncList.AddObject(S, @func);
  result := rb_define_class_under(module, PChar(S)+1, super);
  rb_iv_set(result, '_class', rb_data_object_alloc(ap_cObject, AClass.ClassInfo, nil, nil));
  DefineProp(result, AClass);
  rb_ary_push(vPhiComponents, result);
end;

function Component_type_info(This: Tvalue): Tvalue; cdecl;
begin
  result := TypeInfo_new(cTypeInfo, This);
end;

function Component_prop_info(This, prop: Tvalue): Tvalue; cdecl;
begin
  result := PropInfo_new(cPropInfo, This, prop);
end;

function Component_dump(This, limit_obj: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  limit: Integer;
begin
  real := ap_data_get_struct(This);
  limit := FIX2INT(limit_obj);
  result := rb_str_new2(PChar(ComponentToString1(real, limit, 0)));
end;

function Component_write_res_file(This, name: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  WriteComponentResFile(STR2CSTR(name), real);
  result := Qnil;
end;

function Component_get_component_count(This: Tvalue): Tvalue; cdecl;
var
  real: TComponent;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ComponentCount);
end;

function Component_get_components(This: Tvalue): Tvalue; cdecl;
var
  real: TComponent;
  i: Integer;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  for i := 0 to real.ComponentCount-1 do
    rb_ary_push(result, real.Components[i].tag);
end;

procedure Init_Component;
begin
  cComponent := rb_define_class_under(mPhi, 'Component', ap_cObject);
  rb_define_singleton_method(cComponent, 'type_info', @Component_type_info, 0);
  rb_define_method(cComponent, 'prop_info', @Component_prop_info, 1);
  rb_define_method(cComponent, '_dump', @Component_dump, 1);
  rb_define_method(cComponent, 'write_res_file', @Component_write_res_file, 1);
  DefineAttrGet(cComponent, 'component_count', Component_get_component_count);
  DefineAttrGet(cComponent, 'components', Component_get_components);
end;

exports
  RemoveParentAttr,
  ap_cComponent,
  CompoSetup,
  DefineCompoClass;

end.
