unit uComboBox;

interface

uses Rubies, QStdCtrls;

var
  cComboBox: Tvalue;

function ap_cComboBox: Tvalue; stdcall;
procedure ComboBox_setup(obj: Tvalue; real: TComboBox);
function ComboBox_alloc(This: Tvalue; real: TComboBox): Tvalue; stdcall;
procedure Init_ComboBox;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi, uConv,
  uSizeConstraints, uCanvas, uFont, uStrings,
  uComponent, uControl;

function ap_cComboBox: Tvalue; stdcall;
begin
  result := cComboBox;
end;

procedure ComboBox_setup(obj: Tvalue; real: TComboBox);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@canvas', Canvas_alloc(ap_cCanvas, real.Canvas));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  rb_iv_set(obj, '@items', Strings_alloc(ap_cStrings, real.Items));
  AssignPropMethod(real, [Handle]);
end;

function ComboBox_alloc(This: Tvalue; real: TComboBox): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  ComboBox_setup(result, real);
end;

function ComboBox_alloc_v(var AControl): Tvalue;
begin
  result := ComboBox_alloc(cComboBox, TComboBox(AControl));
end;

function ComboBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := TComboBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ComboBox_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function ComboBox_set_char_case(This, v: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  real.CharCase := TEditCharCase(FIX2INT(v));
  result := v;
end;

function ComboBox_get_char_case(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.CharCase));
end;

function ComboBox_set_item_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  real.ItemIndex := dl_Integer(v);
  result := v;
end;

function ComboBox_get_item_index(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.ItemIndex);
end;

function ComboBox_set_sel_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  real.SelText := dl_String(v);
  result := v;
end;

function ComboBox_get_sel_text(This: Tvalue): Tvalue; cdecl;
var
  real: TComboBox;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.SelText);
end;

procedure Init_ComboBox;
begin
  cComboBox := DefineCompoClass(mPhi, TComboBox, cWinControl, ComboBox_alloc_v);
  DefineSingletonMethod(cComboBox, 'new', ComboBox_new);
  DefineAttrSet(cComboBox, 'char_case', ComboBox_set_char_case);
  DefineAttrGet(cComboBox, 'char_case', ComboBox_get_char_case);
  DefineAttrSet(cComboBox, 'item_index', ComboBox_set_item_index);
  DefineAttrGet(cComboBox, 'item_index', ComboBox_get_item_index);
  DefineAttrSet(cComboBox, 'sel_text', ComboBox_set_sel_text);
  DefineAttrGet(cComboBox, 'sel_text', ComboBox_get_sel_text);
end;

exports
  ap_cComboBox,
  ComboBox_alloc;

end.
